/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.Action;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class ActionDefinition
extends AbstractWidgetDefinition {
    private String actionCommand;
    private ActionListener listener;

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof ActionDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an ActionDefinition.", this.getLocation());
        }
        ActionDefinition other = (ActionDefinition)definition;
        this.actionCommand = other.actionCommand;
        this.listener = other.listener;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Widget createInstance() {
        return new Action(this);
    }

    public void addActionListener(ActionListener listener) {
        this.checkMutable();
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void fireActionEvent(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public boolean hasActionListeners() {
        return this.listener != null;
    }
}

