/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.CreateEvent;
import org.apache.cocoon.forms.event.CreateListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.IncompletenessException;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.formmodel.library.Library;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractWidgetDefinition
implements WidgetDefinition {
    private FormDefinition formDefinition;
    protected WidgetDefinition parent;
    protected Library enclosingLibrary;
    private Location location = Location.UNKNOWN;
    private String id;
    private boolean mutable = true;
    private Map attributes;
    private Map displayData;
    private List validators;
    private WidgetState state = WidgetState.ACTIVE;
    protected CreateListener createListener;

    public FormDefinition getFormDefinition() {
        if (this.formDefinition == null) {
            if (this instanceof FormDefinition) {
                this.formDefinition = (FormDefinition)this;
            } else if (this.parent != null) {
                this.formDefinition = this.parent.getFormDefinition();
            } else {
                return null;
            }
        }
        return this.formDefinition;
    }

    public Library getEnclosingLibrary() {
        if (this.enclosingLibrary == null) {
            this.enclosingLibrary = this.parent.getEnclosingLibrary();
        }
        return this.enclosingLibrary;
    }

    public void setEnclosingLibrary(Library library) {
        this.enclosingLibrary = library;
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        if (!(definition instanceof AbstractWidgetDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an AbstractWidgetDefinition.", this.getLocation());
        }
        AbstractWidgetDefinition other = (AbstractWidgetDefinition)definition;
        this.state = other.state;
        this.createListener = other.createListener;
        this.validators = new ArrayList();
        if (other.validators != null) {
            for (int i = 0; i < other.validators.size(); ++i) {
                this.validators.add(other.validators.get(i));
            }
        }
        if (other.attributes != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.putAll(other.attributes);
        }
        if (other.displayData != null) {
            if (this.displayData == null) {
                this.displayData = new HashMap();
            }
            this.displayData.putAll(other.displayData);
        }
    }

    public void checkCompleteness() throws IncompletenessException {
        if (this.id == null || "".equals(this.id) && !(this instanceof FormDefinition)) {
            throw new IncompletenessException("Widget must have an id attribute.", this);
        }
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    protected void checkMutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Attempt to modify an immutable WidgetDefinition");
        }
    }

    public void setParent(WidgetDefinition definition) {
        this.parent = definition;
    }

    public WidgetDefinition getParent() {
        return this.parent;
    }

    public WidgetState getState() {
        return this.state;
    }

    public void setState(WidgetState state) {
        this.checkMutable();
        this.state = state;
    }

    public void setLocation(Location location) {
        this.checkMutable();
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.checkMutable();
        this.id = id;
    }

    public void setAttributes(Map attributes) {
        this.checkMutable();
        if (this.attributes == null) {
            this.attributes = attributes;
        } else if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void addCreateListener(CreateListener listener) {
        this.checkMutable();
        this.createListener = WidgetEventMulticaster.add(this.createListener, listener);
    }

    public void widgetCreated(Widget widget) {
        if (this.createListener != null) {
            widget.getForm().addWidgetEvent(new CreateEvent(widget));
        }
    }

    public void fireCreateEvent(CreateEvent event) {
        if (event.getSourceWidget().getDefinition() != this) {
            throw new IllegalArgumentException("Widget was not created by this definition");
        }
        if (this.createListener != null) {
            this.createListener.widgetCreated(event);
        }
    }

    public void generateLabel(ContentHandler contentHandler) throws SAXException {
        this.generateDisplayData("label", contentHandler);
    }

    public void setDisplayData(Map displayData) {
        this.checkMutable();
        if (this.displayData == null) {
            this.displayData = displayData;
            return;
        }
        if (displayData == null) {
            return;
        }
        Iterator entries = displayData.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null && this.displayData.containsKey(key)) continue;
            this.displayData.put(key, value);
        }
    }

    public void addValidator(WidgetValidator validator) {
        this.checkMutable();
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void generateDisplayData(String name, ContentHandler contentHandler) throws SAXException {
        Object data = this.displayData.get(name);
        if (data != null) {
            ((XMLizable)data).toSAX(contentHandler);
        } else if (!this.displayData.containsKey(name)) {
            throw new IllegalArgumentException("Unknown display data name '" + name + "'");
        }
    }

    public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        Iterator iter = this.displayData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() == null) continue;
            String name = (String)entry.getKey();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", name, "fi:" + name, XMLUtils.EMPTY_ATTRIBUTES);
            ((XMLizable)entry.getValue()).toSAX(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", name, "fi:" + name);
        }
    }

    public boolean validate(Widget widget) {
        if (this.validators == null) {
            return true;
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            WidgetValidator validator = (WidgetValidator)iter.next();
            if (validator.validate(widget)) continue;
            return false;
        }
        return true;
    }
}

