/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.event.CreateEvent;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractWidget
implements Widget {
    private Widget parent;
    private WidgetState state = WidgetState.ACTIVE;
    private Form form;
    private List validators;
    private Map attributes;
    protected boolean wasValid = true;
    private String cachedParentParamName;
    private String cachedParamName;

    protected AbstractWidget(AbstractWidgetDefinition definition) {
        this.state = definition.getState();
    }

    public void initialize() {
        ((AbstractWidgetDefinition)this.getDefinition()).widgetCreated(this);
    }

    public String getId() {
        return this.getDefinition().getId();
    }

    public String getName() {
        return this.getId();
    }

    public abstract WidgetDefinition getDefinition();

    public Location getLocation() {
        return this.getDefinition().getLocation();
    }

    public final Widget getParent() {
        return this.parent;
    }

    public void setParent(Widget widget) {
        if (this.parent != null) {
            throw new IllegalStateException("The parent of widget " + this.getRequestParameterName() + " should only be set once.");
        }
        this.parent = widget;
    }

    public Form getForm() {
        if (this.form == null) {
            Widget myParent = this.getParent();
            this.form = myParent == null ? (Form)this : myParent.getForm();
        }
        return this.form;
    }

    public WidgetState getState() {
        return this.state;
    }

    public void setState(WidgetState state) {
        if (state == null) {
            throw new IllegalArgumentException("A widget state cannot be set to null");
        }
        this.state = state;
        this.getForm().addWidgetUpdate(this);
    }

    public WidgetState getCombinedState() {
        if (this.parent == null) {
            return this.state;
        }
        return WidgetState.strictest(this.state, this.parent.getCombinedState());
    }

    protected void widgetNameChanged() {
        this.cachedParentParamName = null;
        this.cachedParamName = null;
    }

    public String getFullName() {
        return this.getRequestParameterName();
    }

    public String getRequestParameterName() {
        if (this.parent == null) {
            return this.getId();
        }
        String parentParamName = this.parent.getRequestParameterName();
        if (parentParamName.equals(this.cachedParentParamName)) {
            return this.cachedParamName;
        }
        this.cachedParentParamName = parentParamName;
        this.cachedParamName = this.cachedParentParamName.length() == 0 ? this.getId() : this.cachedParentParamName + "." + this.getId();
        return this.cachedParamName;
    }

    public Widget lookupWidget(String path) {
        String relativePath;
        Widget relativeWidget;
        if (path == null || path.length() == 0) {
            return this;
        }
        int sepPosition = path.indexOf("/");
        if (sepPosition < 0) {
            if (path.startsWith("..")) {
                return this.getParent();
            }
            return this.getChild(path);
        }
        if (sepPosition == 0) {
            relativeWidget = this.getForm();
            relativePath = path.substring(1);
        } else if (path.startsWith("../")) {
            relativeWidget = this.getParent();
            relativePath = path.substring(3);
        } else {
            String childId = path.substring(0, sepPosition);
            relativeWidget = this.getChild(childId);
            relativePath = path.substring(sepPosition + 1);
        }
        if (relativeWidget == null) {
            return null;
        }
        return relativeWidget.lookupWidget(relativePath);
    }

    protected Widget getChild(String id) {
        return null;
    }

    public Widget getWidget(String id) {
        throw new UnsupportedOperationException("getWidget(id) got deprecated from the API. \nConsider using getChild(id) or even lookupWidget(path) instead.");
    }

    public Object getValue() {
        throw new UnsupportedOperationException("Widget " + this + " has no value, at " + this.getLocation());
    }

    public void setValue(Object object) {
        throw new UnsupportedOperationException("Widget " + this + " has no value, at " + this.getLocation());
    }

    public boolean isRequired() {
        return false;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (!(event instanceof CreateEvent)) {
            throw new UnsupportedOperationException("Widget " + this.getRequestParameterName() + " doesn't handle events.");
        }
        ((AbstractWidgetDefinition)this.getDefinition()).fireCreateEvent((CreateEvent)event);
    }

    public void addValidator(WidgetValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public boolean removeValidator(WidgetValidator validator) {
        if (this.validators != null) {
            return this.validators.remove(validator);
        }
        return false;
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        if (!this.getDefinition().validate(this)) {
            this.wasValid = false;
            return false;
        }
        if (this.validators != null) {
            Iterator iter = this.validators.iterator();
            while (iter.hasNext()) {
                WidgetValidator validator = (WidgetValidator)iter.next();
                if (validator.validate(this)) continue;
                this.wasValid = false;
                return false;
            }
        }
        if (this instanceof ValidationErrorAware) {
            ((ValidationErrorAware)((Object)this)).setValidationError(null);
        }
        this.wasValid = true;
        return true;
    }

    public boolean isValid() {
        return this.wasValid;
    }

    public void generateLabel(ContentHandler contentHandler) throws SAXException {
        if (this.getCombinedState().isDisplayingValues()) {
            this.getDefinition().generateDisplayData("label", contentHandler);
        }
    }

    protected void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }

    protected abstract String getXMLElementName();

    protected AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = new AttributesImpl();
        if (this.getId().length() != 0) {
            attrs.addCDATAAttribute("id", this.getRequestParameterName());
        }
        attrs.addCDATAAttribute("state", this.getCombinedState().getName());
        if (this instanceof ValueChangedListenerEnabled && ((ValueChangedListenerEnabled)((Object)this)).hasValueChangedListeners()) {
            attrs.addCDATAAttribute("listening", "true");
        }
        return attrs;
    }

    protected void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        this.getDefinition().generateDisplayData(contentHandler);
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.getCombinedState().isDisplayingValues()) {
            String element = this.getXMLElementName();
            AttributesImpl attrs = this.getXMLElementAttributes();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", element, "fi:" + element, (Attributes)attrs);
            this.generateDisplayData(contentHandler);
            if (locale == null) {
                locale = this.getForm().getLocale();
            }
            this.generateItemSaxFragment(contentHandler, locale);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", element, "fi:" + element);
        } else {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", this.getRequestParameterName());
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder", (Attributes)attrs);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder");
        }
    }

    public Object getAttribute(String name) {
        Object result = null;
        if (this.attributes != null) {
            result = this.attributes.get(name);
        }
        if (result == null) {
            result = this.getDefinition().getAttribute(name);
        }
        return result;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public String toString() {
        String name;
        String className = this.getClass().getName();
        int last = className.lastIndexOf(46);
        if (last != -1) {
            className = className.substring(last + 1);
        }
        return (name = this.getRequestParameterName()).length() == 0 ? className : className + " '" + this.getRequestParameterName() + "'";
    }
}

