/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.DynamicSelectionList;
import org.apache.cocoon.forms.datatype.FlowJXPathSelectionList;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.IncompletenessException;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xmlizer.XMLizer;

public abstract class AbstractDatatypeWidgetDefinition
extends AbstractWidgetDefinition {
    private Datatype datatype;
    private Object initialValue;
    private SelectionList selectionList;
    private ValueChangedListener listener;
    private XMLizer xmlizer;
    private SourceResolver sourceResolver;
    private ProcessInfoProvider processInfoProvider;

    public void checkCompleteness() throws IncompletenessException {
        super.checkCompleteness();
        if (this.datatype == null) {
            throw new IncompletenessException("Widget '" + this.getId() + "' must have a datatype element.", this);
        }
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof AbstractDatatypeWidgetDefinition)) {
            throw new FormsException("Ancestor definition " + definition.getClass().getName() + " is not an AbstractDatatypeWidgetDefinition.", this.getLocation());
        }
        AbstractDatatypeWidgetDefinition other = (AbstractDatatypeWidgetDefinition)definition;
        this.datatype = other.datatype;
        this.initialValue = other.initialValue;
        this.selectionList = other.selectionList;
        this.listener = other.listener;
        this.xmlizer = other.xmlizer;
        this.sourceResolver = other.sourceResolver;
        this.processInfoProvider = other.processInfoProvider;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setDatatype(Datatype datatype, Object initialValue) {
        this.checkMutable();
        this.datatype = datatype;
        this.initialValue = initialValue;
    }

    public void setSelectionList(SelectionList selectionList) {
        this.checkMutable();
        if (selectionList != null && selectionList.getDatatype() != this.getDatatype()) {
            throw new FormsRuntimeException("Tried to assign a selection list that is not associated with this widget's datatype.", this.getLocation());
        }
        this.selectionList = selectionList;
    }

    public SelectionList getSelectionList() {
        return this.selectionList;
    }

    public SelectionList buildSelectionList(String uri) {
        return new DynamicSelectionList(this.datatype, uri, this.xmlizer, this.sourceResolver, this.processInfoProvider.getRequest());
    }

    public SelectionList buildSelectionListFromModel(Object model, String valuePath, String labelPath) {
        return new FlowJXPathSelectionList(model, valuePath, labelPath, this.datatype);
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.checkMutable();
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void fireValueChangedEvent(ValueChangedEvent event) {
        if (this.listener != null) {
            this.listener.valueChanged(event);
        }
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public ValueChangedListener getValueChangedListener() {
        return this.listener;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public void setXmlizer(XMLizer xmlizer) {
        this.xmlizer = xmlizer;
    }

    public void setProcessInfoProvider(ProcessInfoProvider processInfoProvider) {
        this.processInfoProvider = processInfoProvider;
    }
}

