/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinition;
import org.apache.cocoon.forms.formmodel.ContainerDefinition;
import org.apache.cocoon.forms.formmodel.DuplicateIdException;
import org.apache.cocoon.forms.formmodel.IncompletenessException;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionList;

public abstract class AbstractContainerDefinition
extends AbstractWidgetDefinition
implements ContainerDefinition {
    protected WidgetDefinitionList definitions = new WidgetDefinitionList(this);

    public void createWidget(Widget parent, String id) {
        this.definitions.createWidget(parent, id);
    }

    public void createWidgets(Widget parent) {
        this.definitions.createWidgets(parent);
    }

    public void initializeFrom(WidgetDefinition definition) throws Exception {
        super.initializeFrom(definition);
        if (!(definition instanceof AbstractContainerDefinition)) {
            throw new FormsException("Parent definition " + definition.getClass().getName() + " is not an AbstractContainerDefinition.", this.getLocation());
        }
        AbstractContainerDefinition other = (AbstractContainerDefinition)definition;
        Iterator i = other.definitions.getWidgetDefinitions().iterator();
        while (i.hasNext()) {
            try {
                WidgetDefinition def = (WidgetDefinition)i.next();
                this.definitions.addWidgetDefinition(def);
            }
            catch (DuplicateIdException e) {}
        }
    }

    public void checkCompleteness() throws IncompletenessException {
        super.checkCompleteness();
        this.definitions.checkCompleteness();
    }

    public void addWidgetDefinition(WidgetDefinition definition) throws Exception, DuplicateIdException {
        definition.setParent(this);
        this.definitions.addWidgetDefinition(definition);
    }

    public void resolve(List parents, WidgetDefinition parent) throws Exception {
        this.definitions.resolve(parents, parent);
    }

    public boolean hasWidget(String id) {
        return this.definitions.hasWidget(id);
    }

    public WidgetDefinition getWidgetDefinition(String id) {
        return this.definitions.getWidgetDefinition(id);
    }

    public Collection getWidgetDefinitions() {
        return this.definitions.getWidgetDefinitions();
    }
}

