/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.event.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.forms.event.ConfigurableWidgetListener;
import org.apache.cocoon.forms.event.ProcessingPhaseEvent;
import org.apache.cocoon.forms.event.ProcessingPhaseListener;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequiredControl
implements ProcessingPhaseListener,
ConfigurableWidgetListener {
    protected final List descriptions = new ArrayList();

    public void setConfiguration(Element element) throws Exception {
        NodeList nodes = element.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("required")) continue;
            NamedNodeMap attributes = node.getAttributes();
            RequiredDescription desc = null;
            String refId = null;
            String submitId = null;
            String widgetPath = null;
            String widgetValue = null;
            int length = attributes.getLength();
            for (int j = 0; j < length; ++j) {
                Node attr = attributes.item(j);
                String name = attr.getNodeName();
                if ("widget-id".equals(name)) {
                    refId = attr.getNodeValue();
                    continue;
                }
                if ("submit-id".equals(name)) {
                    submitId = attr.getNodeValue();
                    continue;
                }
                if ("widget-path".equals(name)) {
                    widgetPath = attr.getNodeValue();
                    continue;
                }
                if (!"widget-value".equals(name)) continue;
                widgetValue = attr.getNodeValue();
            }
            desc = submitId != null ? new RequiredDescription(refId, submitId) : new RequiredDescription(refId, widgetPath, widgetValue);
            this.descriptions.add(desc);
        }
    }

    public void phaseEnded(ProcessingPhaseEvent event) {
        if (event.getPhase().getValue() == 1 || event.getPhase().getValue() == 0) {
            Iterator i = this.descriptions.iterator();
            while (i.hasNext()) {
                RequiredDescription desc = (RequiredDescription)i.next();
                desc.process(event.getSourceWidget());
            }
        }
    }

    protected static final class RequiredDescription {
        static final int DEPENDS_REQUIRED_MODE = 1;
        static final int SUBMIT_REQUIRED_MODE = 2;
        protected final int mode;
        protected final String referenceId;
        protected String widgetName;
        protected String widgetValue;

        public RequiredDescription(String referenceId, String submitId) {
            this.mode = 2;
            this.referenceId = referenceId;
            this.widgetName = submitId;
        }

        public RequiredDescription(String referenceId, String widget, String value) {
            this.mode = 1;
            this.referenceId = referenceId;
            this.widgetName = widget;
            this.widgetValue = value;
        }

        public void process(Widget form) {
            Widget widget = form.lookupWidget(this.referenceId);
            if (widget == null) {
                throw new IllegalArgumentException("Widget '" + this.referenceId + "' not found in form.");
            }
            if (!(widget instanceof Field)) {
                throw new IllegalArgumentException("Widget '" + widget.getRequestParameterName() + "' is not a Field");
            }
            boolean required = false;
            if (this.mode == 1) {
                Widget w = form.lookupWidget(this.widgetName);
                if (w != null && w.getValue() != null && w.getValue().equals(this.widgetValue)) {
                    required = true;
                }
            } else if (this.mode == 2 && widget.getForm().getSubmitWidget() != null && this.widgetName.equals(widget.getForm().getSubmitWidget().getId())) {
                required = true;
            }
            ((Field)widget).setRequired(required);
        }
    }
}

