/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.event.impl;

import java.util.Map;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.CreateEvent;
import org.apache.cocoon.forms.event.CreateListener;
import org.apache.cocoon.forms.event.ProcessingPhaseEvent;
import org.apache.cocoon.forms.event.ProcessingPhaseListener;
import org.apache.cocoon.forms.event.RepeaterEvent;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.tree.TreeSelectionEvent;
import org.apache.cocoon.forms.formmodel.tree.TreeSelectionListener;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.mozilla.javascript.Function;

public abstract class JavaScriptWidgetListener {
    private Function func;
    private ProcessInfoProvider processInfoProvider;

    public JavaScriptWidgetListener(Function func, ProcessInfoProvider processInfoProvider) {
        this.func = func;
        this.processInfoProvider = processInfoProvider;
    }

    protected void callScript(WidgetEvent event) {
        try {
            Map objectModel = this.processInfoProvider.getObjectModel();
            Widget w = event.getSourceWidget();
            JavaScriptHelper.callFunction(this.func, w, new Object[]{w, event}, objectModel);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking JavaScript event handler", e);
        }
    }

    public static class JSRepeaterListener
    extends JavaScriptWidgetListener
    implements RepeaterListener {
        public JSRepeaterListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void repeaterModified(RepeaterEvent event) {
            super.callScript(event);
        }
    }

    public static class JSProcessingPhaseListener
    extends JavaScriptWidgetListener
    implements ProcessingPhaseListener {
        public JSProcessingPhaseListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void phaseEnded(ProcessingPhaseEvent event) {
            super.callScript(event);
        }
    }

    public static class JSTreeSelectionListener
    extends JavaScriptWidgetListener
    implements TreeSelectionListener {
        public JSTreeSelectionListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void selectionChanged(TreeSelectionEvent event) {
            super.callScript(event);
        }
    }

    public static class JSCreateListener
    extends JavaScriptWidgetListener
    implements CreateListener {
        public JSCreateListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void widgetCreated(CreateEvent event) {
            super.callScript(event);
        }
    }

    public static class JSValueChangedListener
    extends JavaScriptWidgetListener
    implements ValueChangedListener {
        public JSValueChangedListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void valueChanged(ValueChangedEvent event) {
            super.callScript(event);
        }
    }

    public static class JSActionListener
    extends JavaScriptWidgetListener
    implements ActionListener {
        public JSActionListener(Function func, ProcessInfoProvider processInfoProvider) {
            super(func, processInfoProvider);
        }

        public void actionPerformed(ActionEvent event) {
            super.callScript(event);
        }
    }
}

