/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.event.impl;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ConfigurableWidgetListener;
import org.apache.cocoon.forms.event.WidgetListener;
import org.apache.cocoon.forms.event.WidgetListenerBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.w3c.dom.Element;

public class JavaClassWidgetListenerBuilder
implements WidgetListenerBuilder,
BeanFactoryAware {
    private static Log LOG = LogFactory.getLog((Class)JavaClassWidgetListenerBuilder.class);
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public WidgetListener buildListener(Element element, Class listenerClass) throws Exception {
        if (DomHelper.getAttribute(element, "class", null) != null) {
            throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(element) + ". Use a 'ref' attribute to address a Spring bean");
        }
        String name = DomHelper.getAttribute(element, "ref");
        try {
            Object listener = this.beanFactory.getBean(name);
            if (listener != null && listenerClass.isAssignableFrom(listener.getClass())) {
                if (listener instanceof ConfigurableWidgetListener) {
                    ((ConfigurableWidgetListener)listener).setConfiguration(element);
                }
                return (WidgetListener)listener;
            }
            throw new FormsException("Bean referenced by " + name + " is not a " + listenerClass.getName(), DomHelper.getLocationObject(element));
        }
        catch (BeansException be) {
            throw new FormsException("Bean referenced by " + name + " doesn't exist in Spring context", be, DomHelper.getLocationObject(element));
        }
    }
}

