/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.oro.text.perl.Perl5Util;
import org.outerj.expression.ExpressionContext;

public class EmailValidationRule
extends AbstractValidationRule {
    private static final String SPECIAL_CHARS = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String ATOM = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+";
    private static final String WORD = "([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_PATTERN = "/^[\\000-\\177]+$/";
    private static final String EMAIL_PATTERN = "/^(.+)@(.+)$/";
    private static final String IP_DOMAIN_PATTERN = "/^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$/";
    private static final String USER_PATTERN = "/^([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))(\\.([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\")))*$/";
    private static final String DOMAIN_PATTERN = "/^[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+(\\.[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)*$/";
    private static final String ATOM_PATTERN = "/([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)/";

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        String email = (String)value;
        if (this.isEmail(email)) {
            return null;
        }
        return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.string.invalidemail", "forms"));
    }

    public boolean supportsType(Class clazz, boolean arrayType) {
        return clazz.isAssignableFrom(String.class) && !arrayType;
    }

    boolean isEmail(String email) {
        if (email == null) {
            return false;
        }
        Perl5Util matchAsciiPat = new Perl5Util();
        if (!matchAsciiPat.match(LEGAL_ASCII_PATTERN, email)) {
            return false;
        }
        Perl5Util emailMatcher = new Perl5Util();
        if (!emailMatcher.match(EMAIL_PATTERN, email)) {
            return false;
        }
        if (email.endsWith(".")) {
            return false;
        }
        if (!this.isValidUser(emailMatcher.group(1))) {
            return false;
        }
        return this.isValidDomain(emailMatcher.group(2));
    }

    protected boolean isValidDomain(String domain) {
        boolean symbolic = false;
        Perl5Util ipAddressMatcher = new Perl5Util();
        if (ipAddressMatcher.match(IP_DOMAIN_PATTERN, domain)) {
            if (!this.isValidIpAddress(ipAddressMatcher)) {
                return false;
            }
        } else {
            Perl5Util domainMatcher = new Perl5Util();
            symbolic = domainMatcher.match(DOMAIN_PATTERN, domain);
        }
        if (symbolic) {
            return this.isValidSymbolicDomain(domain);
        }
        return false;
    }

    protected boolean isValidUser(String user) {
        Perl5Util userMatcher = new Perl5Util();
        return userMatcher.match(USER_PATTERN, user);
    }

    protected boolean isValidIpAddress(Perl5Util ipAddressMatcher) {
        for (int i = 1; i <= 4; ++i) {
            String ipSegment = ipAddressMatcher.group(i);
            if (ipSegment == null || ipSegment.length() <= 0) {
                return false;
            }
            int iIpSegment = 0;
            try {
                iIpSegment = Integer.parseInt(ipSegment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (iIpSegment <= 255) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidSymbolicDomain(String domain) {
        String[] domainSegment = new String[10];
        boolean match = true;
        int i = 0;
        Perl5Util atomMatcher = new Perl5Util();
        while (match) {
            match = atomMatcher.match(ATOM_PATTERN, domain);
            if (!match) continue;
            domainSegment[i] = atomMatcher.group(1);
            int l = domainSegment[i].length() + 1;
            domain = l >= domain.length() ? "" : domain.substring(l);
            ++i;
        }
        int len = i;
        if (domainSegment[len - 1].length() < 2 || domainSegment[len - 1].length() > 4) {
            return false;
        }
        return len >= 2;
    }
}

