/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.outerj.daisy.htmlcleaner.HtmlCleaner;
import org.outerj.daisy.htmlcleaner.HtmlCleanerTemplate;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HtmlCleaningConvertor
implements Convertor {
    HtmlCleanerTemplate template;

    public HtmlCleaningConvertor(HtmlCleanerTemplate template) {
        this.template = template;
    }

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        HtmlCleaner cleaner = this.template.newHtmlCleaner();
        try {
            String result = cleaner.cleanToString(value);
            return new ConversionResult(result);
        }
        catch (Exception e) {
            String message;
            Throwable t = ExceptionUtils.getRootCause((Throwable)e);
            if (t == null) {
                t = e;
            }
            if ((message = t.getMessage()) == null) {
                message = t.toString();
            }
            ValidationError validationError = new ValidationError(message, false);
            return new ConversionResult(validationError);
        }
    }

    public String convertToString(Object object, Locale locale, Convertor.FormatCache formatCache) {
        return (String)object;
    }

    public Class getTypeClass() {
        return String.class;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }
}

