/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.LocaleMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormattingDecimalConvertor
implements Convertor {
    private int variant = this.getDefaultVariant();
    private LocaleMap localizedPatterns = new LocaleMap();
    private String nonLocalizedPattern;
    public static final int INTEGER = 0;
    public static final int NUMBER = 1;
    public static final int CURRENCY = 2;
    public static final int PERCENT = 3;

    protected int getDefaultVariant() {
        return 1;
    }

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        Number decimalValue;
        value = value.replace(' ', '\u00a0');
        DecimalFormat decimalFormat = this.getDecimalFormat(locale, formatCache);
        try {
            decimalValue = decimalFormat.parse(value);
        }
        catch (ParseException e) {
            return ConversionResult.create("decimal");
        }
        if (!(decimalValue instanceof BigDecimal)) {
            if (decimalValue instanceof Integer) {
                decimalValue = new BigDecimal((double)decimalValue.intValue());
            } else if (decimalValue instanceof Long) {
                decimalValue = new BigDecimal((double)decimalValue.longValue());
            } else if (decimalValue instanceof Double) {
                decimalValue = new BigDecimal(decimalValue.doubleValue());
            } else if (decimalValue instanceof BigInteger) {
                decimalValue = new BigDecimal((BigInteger)decimalValue);
            } else {
                return ConversionResult.create("decimal");
            }
        }
        return new ConversionResult(decimalValue);
    }

    public String convertToString(Object value, Locale locale, Convertor.FormatCache formatCache) {
        DecimalFormat decimalFormat = this.getDecimalFormat(locale, formatCache);
        return decimalFormat.format(value);
    }

    protected final DecimalFormat getDecimalFormat(Locale locale, Convertor.FormatCache formatCache) {
        DecimalFormat decimalFormat = null;
        if (formatCache != null) {
            decimalFormat = (DecimalFormat)formatCache.get();
        }
        if (decimalFormat == null) {
            decimalFormat = this.getDecimalFormat(locale);
            if (formatCache != null) {
                formatCache.store(decimalFormat);
            }
        }
        return decimalFormat;
    }

    private DecimalFormat getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = null;
        switch (this.variant) {
            case 0: {
                decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                decimalFormat.setMaximumFractionDigits(0);
                decimalFormat.setDecimalSeparatorAlwaysShown(false);
                decimalFormat.setParseIntegerOnly(true);
                break;
            }
            case 1: {
                decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                break;
            }
            case 2: {
                decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
                break;
            }
            case 3: {
                decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            }
        }
        String pattern = (String)this.localizedPatterns.get(locale);
        if (pattern != null) {
            decimalFormat.applyPattern(pattern);
        } else if (this.nonLocalizedPattern != null) {
            decimalFormat.applyPattern(this.nonLocalizedPattern);
        }
        return decimalFormat;
    }

    public void setVariant(int variant) {
        if (variant != 0 && variant != 1 && variant != 2 && variant != 3) {
            throw new IllegalArgumentException("Invalid value for variant parameter.");
        }
        this.variant = variant;
    }

    public void addFormattingPattern(Locale locale, String pattern) {
        this.localizedPatterns.put(locale, pattern);
    }

    public void setNonLocalizedPattern(String pattern) {
        this.nonLocalizedPattern = pattern;
    }

    public Class getTypeClass() {
        return BigDecimal.class;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }
}

