/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.DateConvertorBuilder;
import org.apache.cocoon.forms.datatype.convertor.FormattingDateConvertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.w3c.dom.Element;

public class FormattingDateConvertorBuilder
implements DateConvertorBuilder {
    public Convertor build(Element configElement) throws Exception {
        Element patternsEl;
        String lenient;
        String variant;
        String timeStyle;
        FormattingDateConvertor convertor = new FormattingDateConvertor();
        if (configElement == null) {
            return convertor;
        }
        String style = configElement.getAttribute("style");
        if (!style.equals("")) {
            int parsedStyle = this.parseDateTimeStyle(style);
            if (parsedStyle == -1) {
                throw new Exception("Invalid value \"" + style + "\" for style attribute at " + DomHelper.getLocation(configElement));
            }
            convertor.setStyle(parsedStyle);
        }
        if (!(timeStyle = configElement.getAttribute("timeStyle")).equals("")) {
            int parsedStyle = this.parseDateTimeStyle(timeStyle);
            if (parsedStyle == -1) {
                throw new Exception("Invalid value \"" + timeStyle + "\" for timeStyle attribute at " + DomHelper.getLocation(configElement));
            }
            convertor.setTimeStyle(parsedStyle);
        }
        if (!(variant = configElement.getAttribute("variant")).equals("")) {
            if (variant.equals("date") || variant.equals("time") || variant.equals("datetime")) {
                convertor.setVariant(variant);
            } else {
                throw new Exception("Invalid value \"" + variant + "\" for variant attribute at " + DomHelper.getLocation(configElement));
            }
        }
        if (!(lenient = configElement.getAttribute("lenient")).equals("")) {
            if (lenient.equals("false") || lenient.equals("no")) {
                convertor.setLenient(false);
            } else if (lenient.equals("true") || lenient.equals("yes")) {
                convertor.setLenient(true);
            } else {
                throw new Exception("Invalid value \"" + lenient + "\" for lenient attribute at " + DomHelper.getLocation(configElement));
            }
        }
        if ((patternsEl = DomHelper.getChildElement(configElement, "http://apache.org/cocoon/forms/1.0#definition", "patterns", false)) != null) {
            Element[] patternEl = DomHelper.getChildElements(patternsEl, "http://apache.org/cocoon/forms/1.0#definition", "pattern");
            for (int i = 0; i < patternEl.length; ++i) {
                String locale = patternEl[i].getAttribute("locale");
                String pattern = DomHelper.getElementText(patternEl[i]);
                if (pattern.length() == 0) {
                    throw new Exception("pattern element does not contain any content at " + DomHelper.getLocation(patternEl[i]));
                }
                if (locale.length() == 0) {
                    convertor.setNonLocalizedPattern(pattern);
                    continue;
                }
                Locale loc = I18nUtils.parseLocale((String)locale);
                convertor.addFormattingPattern(loc, pattern);
            }
        }
        return convertor;
    }

    private int parseDateTimeStyle(String style) {
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("long")) {
            return 1;
        }
        if (style.equals("full")) {
            return 0;
        }
        return -1;
    }
}

