/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.jxpath.JXPathContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BeanConvertor
implements Convertor {
    private Class m_class;
    private Map m_objects = new ReferenceMap();
    private String m_idPath;

    public BeanConvertor(String className, String idPath) {
        try {
            this.m_class = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + className + " not found", e);
        }
        this.m_idPath = idPath;
    }

    public Class getTypeClass() {
        return this.m_class;
    }

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        return new ConversionResult(this.m_objects.get(value));
    }

    public String convertToString(Object value, Locale locale, Convertor.FormatCache formatCache) {
        String idValue = "";
        if (null != value) {
            if (this.m_idPath != null) {
                JXPathContext ctx = JXPathContext.newContext((Object)value);
                idValue = ctx.getValue(this.m_idPath).toString();
            } else {
                idValue = value.toString();
            }
        }
        this.m_objects.put(idValue, value);
        return idValue;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
    }
}

