/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.FilterableSelectionList;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.util.location.Locatable;
import org.apache.cocoon.util.location.LocatedRuntimeException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JavaScriptSelectionList
implements FilterableSelectionList,
Locatable {
    private ProcessInfoProvider processInfoProvider;
    private Datatype type;
    private Function function;
    private Location location = null;
    private boolean labelIsI18nKey = false;
    private String i18nCatalog = null;

    public JavaScriptSelectionList(ProcessInfoProvider processInfoProvider, Datatype type, Function function, String catalogue, Location location) {
        this.processInfoProvider = processInfoProvider;
        this.type = type;
        this.function = function;
        this.location = location;
        if (catalogue != null) {
            this.labelIsI18nKey = true;
            if (catalogue.length() > 0) {
                this.i18nCatalog = catalogue;
            }
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        this.generateSaxFragment(contentHandler, locale, null);
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale, String filter) throws SAXException {
        Object result;
        Map objectModel = this.processInfoProvider.getObjectModel();
        try {
            result = JavaScriptHelper.callFunction(this.function, null, new Object[]{filter}, objectModel);
        }
        catch (JavaScriptException e) {
            throw new LocatedRuntimeException("Error building JS selection list", (Throwable)e, this.getLocation());
        }
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", XMLUtils.EMPTY_ATTRIBUTES);
        NativeArray array = (NativeArray)result;
        int i = 0;
        while ((long)i < array.jsGet_length()) {
            Scriptable item = (Scriptable)array.get(i, (Scriptable)array);
            Object value = item.get("value", item);
            String stringValue = value == null ? "" : this.type.convertToString(value, locale);
            Object label = item.get("label", item);
            if (label == Scriptable.NOT_FOUND) {
                label = null;
            }
            AttributesImpl itemAttrs = new AttributesImpl();
            itemAttrs.addCDATAAttribute("value", stringValue);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)itemAttrs);
            if (label != null) {
                String stringLabel;
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
                if (label instanceof XMLizable) {
                    ((XMLizable)label).toSAX(contentHandler);
                } else if (this.labelIsI18nKey) {
                    stringLabel = label.toString();
                    if (this.i18nCatalog != null && this.i18nCatalog.trim().length() > 0) {
                        new I18nMessage(stringLabel, this.i18nCatalog).toSAX(contentHandler);
                    } else {
                        new I18nMessage(stringLabel).toSAX(contentHandler);
                    }
                } else {
                    stringLabel = label.toString();
                    contentHandler.characters(stringLabel.toCharArray(), 0, stringLabel.length());
                }
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
            ++i;
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
    }

    public Datatype getDatatype() {
        return this.type;
    }
}

