/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FlowJXPathSelectionList
implements SelectionList {
    private ProcessInfoProvider processInfoProvider;
    private String listPath;
    private String valuePath;
    private String labelPath;
    private Datatype datatype;
    private Object model;
    private boolean nullable = false;
    private String nullText;
    private boolean nullTextIsI18nKey = false;
    private String i18nCatalog;
    private boolean labelIsI18nKey = false;

    public FlowJXPathSelectionList(ProcessInfoProvider processInfoProvider, String listPath, String valuePath, String labelPath, Datatype datatype, String nullText, boolean nullTextIsI18nKey, String i18nCatalog, boolean labelIsI18nKey) {
        this.processInfoProvider = processInfoProvider;
        this.listPath = listPath;
        this.valuePath = valuePath;
        this.labelPath = labelPath;
        this.datatype = datatype;
        this.nullText = nullText;
        this.nullable = nullText != null;
        this.nullTextIsI18nKey = nullTextIsI18nKey;
        this.i18nCatalog = i18nCatalog;
        this.labelIsI18nKey = labelIsI18nKey;
    }

    public FlowJXPathSelectionList(Object model, String valuePath, String labelPath, Datatype datatype) {
        this.model = model;
        this.valuePath = valuePath;
        this.labelPath = labelPath;
        this.datatype = datatype;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        JXPathContext ctx = null;
        Iterator iter = null;
        if (this.model == null) {
            Object flowData = FlowHelper.getContextObject((Map)this.processInfoProvider.getObjectModel());
            if (flowData == null) {
                throw new SAXException("No flow data to produce selection list");
            }
            ctx = JXPathContext.newContext((Object)flowData);
            iter = ctx.iteratePointers(this.listPath);
        } else {
            ctx = JXPathContext.newContext((Object)this.model);
            iter = ctx.iteratePointers(".");
        }
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list", XMLUtils.EMPTY_ATTRIBUTES);
        if (this.nullable) {
            AttributesImpl voidAttrs = new AttributesImpl();
            voidAttrs.addCDATAAttribute("value", "");
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)voidAttrs);
            if (this.nullText != null) {
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
                if (this.nullTextIsI18nKey) {
                    if (this.i18nCatalog != null && this.i18nCatalog.trim().length() > 0) {
                        new I18nMessage(this.nullText, this.i18nCatalog).toSAX(contentHandler);
                    } else {
                        new I18nMessage(this.nullText).toSAX(contentHandler);
                    }
                } else {
                    contentHandler.characters(this.nullText.toCharArray(), 0, this.nullText.length());
                }
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
        while (iter.hasNext()) {
            String stringValue = "";
            Object label = null;
            Pointer ptr = (Pointer)iter.next();
            if (ptr.getValue() != null) {
                JXPathContext itemCtx = ctx.getRelativeContext(ptr);
                Object value = itemCtx.getValue(this.valuePath);
                if (value != null) {
                    stringValue = this.datatype.convertToString(value, locale);
                }
                if (this.labelPath != null) {
                    itemCtx.setLenient(true);
                    label = itemCtx.getValue(this.labelPath);
                }
            }
            AttributesImpl itemAttrs = new AttributesImpl();
            itemAttrs.addCDATAAttribute("value", stringValue);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item", (Attributes)itemAttrs);
            if (label != null) {
                String stringLabel;
                contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label", XMLUtils.EMPTY_ATTRIBUTES);
                if (label instanceof XMLizable) {
                    ((XMLizable)label).toSAX(contentHandler);
                } else if (this.labelIsI18nKey) {
                    stringLabel = label.toString();
                    if (this.i18nCatalog != null && this.i18nCatalog.trim().length() > 0) {
                        new I18nMessage(stringLabel, this.i18nCatalog).toSAX(contentHandler);
                    } else {
                        new I18nMessage(stringLabel).toSAX(contentHandler);
                    }
                } else {
                    stringLabel = label.toString();
                    contentHandler.characters(stringLabel.toCharArray(), 0, stringLabel.length());
                }
                contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "label", "fi:label");
            }
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "item", "fi:item");
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "selection-list", "fi:selection-list");
    }
}

