/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding.library;

import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.library.Library;
import org.apache.cocoon.forms.binding.library.LibraryException;
import org.apache.cocoon.forms.binding.library.LibraryManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class LibraryManagerImpl
implements LibraryManager {
    private static Log LOG = LogFactory.getLog((Class)LibraryManagerImpl.class);
    protected static final String PREFIX = "CocoonFormBindingLibrary:";
    private CacheManager cacheManager;
    private JXPathBindingManager bindingManager;
    private SourceResolver sourceResolver;
    private SAXParser parser;

    public void setBindingManager(JXPathBindingManager bindingManager) {
        this.bindingManager = bindingManager;
    }

    public Library get(String sourceURI) throws LibraryException {
        return this.get(sourceURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library get(String sourceURI, String baseURI) throws LibraryException {
        Library library;
        block11: {
            Library lib;
            Source source;
            block9: {
                Library library2;
                block10: {
                    source = null;
                    try {
                        try {
                            source = this.sourceResolver.resolveURI(sourceURI, baseURI, null);
                        }
                        catch (Exception e) {
                            throw new LibraryException("Unable to resolve library.", e, (Location)new LocationImpl("[LibraryManager]", sourceURI));
                        }
                        lib = (Library)this.cacheManager.get(source, PREFIX);
                        if (lib == null || !lib.dependenciesHaveChanged()) break block9;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Library IS REMOVED from cache: '" + sourceURI + "' relative to '" + baseURI + "'"));
                        }
                        this.cacheManager.remove(source, PREFIX);
                        library2 = null;
                        Object var7_8 = null;
                        if (source == null) break block10;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var7_10 = null;
                            if (source == null) break block12;
                            this.sourceResolver.release(source);
                        }
                        throw throwable;
                    }
                    this.sourceResolver.release(source);
                }
                return library2;
            }
            if (LOG.isDebugEnabled()) {
                if (lib != null) {
                    LOG.debug((Object)("Library IS in cache: '" + sourceURI + "' relative to '" + baseURI + "'"));
                } else {
                    LOG.debug((Object)("Library IS NOT in cache: '" + sourceURI + "' relative to '" + baseURI + "'"));
                }
            }
            library = lib;
            Object var7_9 = null;
            if (source == null) break block11;
            this.sourceResolver.release(source);
        }
        return library;
    }

    public Library load(String sourceURI) throws LibraryException {
        return this.load(sourceURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library load(String sourceURI, String baseURI) throws LibraryException {
        Library library;
        block12: {
            Source source = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading library: '" + sourceURI + "' relative to '" + baseURI + "'"));
            }
            try {
                try {
                    source = this.sourceResolver.resolveURI(sourceURI, baseURI, null);
                }
                catch (Exception e) {
                    throw new LibraryException("Unable to resolve library.", e, (Location)new LocationImpl("[LibraryManager]", sourceURI));
                }
                Library lib = (Library)this.cacheManager.get(source, PREFIX);
                if (lib != null && lib.dependenciesHaveChanged()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Library IS EXPIRED in cache: '" + sourceURI + "' relative to '" + baseURI + "'"));
                    }
                    lib = null;
                }
                if (lib == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Library IS NOT in cache, loading: '" + sourceURI + "' relative to '" + baseURI + "'"));
                    }
                    try {
                        InputSource inputSource = new InputSource(source.getInputStream());
                        inputSource.setSystemId(source.getURI());
                        Document doc = DomHelper.parse(inputSource, this.parser);
                        lib = this.newLibrary();
                        lib.buildLibrary(doc.getDocumentElement());
                        this.cacheManager.set(lib, source, PREFIX);
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new LibraryException("Unable to load library.", e, (Location)new LocationImpl("[LibraryManager]", source.getURI()));
                    }
                }
                library = lib;
                Object var8_10 = null;
                if (source == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var8_11 = null;
                    if (source == null) break block13;
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        return library;
    }

    public Library newLibrary() {
        Library lib = new Library(this, this.bindingManager.getBuilderAssistant());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new library! " + lib));
        }
        return lib;
    }

    public void debug(String msg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)msg);
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }
}

