/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.library.LibraryException;
import org.apache.cocoon.forms.binding.library.LibraryManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.location.LocationAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Library {
    private static Log LOG = LogFactory.getLog((Class)Library.class);
    public static final String SEPARATOR = ":";
    protected LibraryManager manager;
    protected Map definitions = new HashMap();
    protected Map inclusions = new HashMap();
    protected final Object shared = new Object();
    protected String sourceURI;
    protected JXPathBindingManager.Assistant assistant;

    public Library(LibraryManager lm, JXPathBindingManager.Assistant assistant) {
        this.manager = lm;
        this.assistant = assistant;
    }

    public void setSourceURI(String uri) {
        this.sourceURI = uri;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public boolean dependenciesHaveChanged() throws LibraryException {
        Iterator i = this.inclusions.values().iterator();
        while (i.hasNext()) {
            Dependency dep = (Dependency)i.next();
            if (dep.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean includeAs(String key, String sourceURI) throws LibraryException {
        if (!this.inclusions.containsKey(key) || key.indexOf(SEPARATOR) > -1) {
            this.manager.load(sourceURI, this.sourceURI);
            this.inclusions.put(key, new Dependency(sourceURI));
            return true;
        }
        return false;
    }

    public Binding getBinding(String key) throws LibraryException {
        String librarykey = null;
        String definitionkey = key;
        if (key.indexOf(SEPARATOR) > -1) {
            String[] parts = StringUtils.split((String)key, (String)SEPARATOR);
            librarykey = parts[0];
            definitionkey = parts[1];
            for (int i = 2; i < parts.length; ++i) {
                definitionkey = definitionkey + SEPARATOR + parts[i];
            }
        }
        if (librarykey != null) {
            Dependency dependency = (Dependency)this.inclusions.get(librarykey);
            if (dependency != null) {
                try {
                    return this.manager.load(dependency.dependencyURI, this.sourceURI).getBinding(definitionkey);
                }
                catch (Exception e) {
                    throw new LibraryException("Couldn't get library '" + librarykey + "' source='" + dependency + "'", e);
                }
            }
            throw new LibraryException("Library '" + librarykey + "' does not exist! (lookup: '" + key + "')");
        }
        return (Binding)this.definitions.get(definitionkey);
    }

    public void buildLibrary(Element libraryElement) throws Exception {
        this.sourceURI = LocationAttributes.getURI((Element)libraryElement);
        this.assistant.getContext().setLocalLibrary(this);
        Element[] bindingElements = DomHelper.getChildElements(libraryElement, "http://apache.org/cocoon/forms/1.0#binding");
        for (int i = 0; i < bindingElements.length; ++i) {
            Element bindingElement = bindingElements[i];
            JXPathBindingBase binding = this.assistant.getBindingForConfigurationElement(bindingElement);
            this.addBinding(binding);
        }
    }

    public void addBinding(Binding binding) throws LibraryException {
        if (binding == null) {
            return;
        }
        if (this.definitions.containsKey(binding.getId())) {
            throw new LibraryException("Library already contains a binding with this ID!");
        }
        binding.setEnclosingLibrary(this);
        this.definitions.put(binding.getId(), binding);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + ": Added binding '" + binding.getId() + "'"));
        }
    }

    protected class Dependency {
        private final String dependencyURI;
        private final Object shared;

        public Dependency(String dependencySourceURI) throws LibraryException {
            this.dependencyURI = dependencySourceURI;
            Library lib = Library.this.manager.load(this.dependencyURI, Library.this.sourceURI);
            this.shared = lib.shared;
        }

        public boolean isValid() throws LibraryException {
            Library lib = Library.this.manager.get(this.dependencyURI, Library.this.sourceURI);
            return lib != null && this.shared == lib.shared;
        }
    }
}

