/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Locale;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.w3c.dom.Element;

public class ValueJXPathBindingBuilder
extends JXPathBindingBuilderBase {
    public JXPathBindingBase buildBinding(Element bindingElm, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(bindingElm);
            String xpath = DomHelper.getAttribute(bindingElm, "path", null);
            String widgetId = DomHelper.getAttribute(bindingElm, "id", null);
            Convertor convertor = null;
            Locale convertorLocale = Locale.US;
            Element convertorEl = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#definition", "convertor");
            if (convertorEl != null) {
                String datatype = DomHelper.getAttribute(convertorEl, "datatype");
                String localeStr = DomHelper.getAttribute(convertorEl, "locale", null);
                if (localeStr != null) {
                    convertorLocale = I18nUtils.parseLocale((String)localeStr);
                }
                convertor = assistant.getDatatypeManager().createConvertor(datatype, convertorEl);
            }
            ValueJXPathBinding otherBinding = (ValueJXPathBinding)assistant.getContext().getSuperBinding();
            JXPathBindingBase[] existingUpdateBindings = null;
            if (otherBinding != null) {
                commonAtts = JXPathBindingBuilderBase.mergeCommonAttributes(otherBinding.getCommonAtts(), commonAtts);
                if (xpath == null) {
                    xpath = otherBinding.getXPath();
                }
                if (widgetId == null) {
                    widgetId = otherBinding.getId();
                }
                if (convertor == null) {
                    convertor = otherBinding.getConvertor();
                }
                if (convertorLocale == null) {
                    convertorLocale = otherBinding.getConvertorLocale();
                }
                if (convertorLocale == null) {
                    convertorLocale = otherBinding.getConvertorLocale();
                }
                existingUpdateBindings = otherBinding.getUpdateBinding().getChildBindings();
            }
            Element updateWrapElement = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "on-update");
            JXPathBindingBase[] updateBindings = assistant.makeChildBindings(updateWrapElement, existingUpdateBindings);
            return new ValueJXPathBinding(commonAtts, widgetId, xpath, updateBindings, convertor, convertorLocale);
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building binding", e, DomHelper.getLocationObject(bindingElm));
        }
    }
}

