/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.forms.binding.RepeaterAdapter;
import org.apache.cocoon.forms.binding.RepeaterFilter;
import org.apache.cocoon.forms.binding.RepeaterItem;
import org.apache.cocoon.forms.binding.RepeaterSorter;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.commons.jxpath.JXPathContext;

public class RepeaterJXPathCollection {
    private JXPathContext storageContext;
    private Map updatedRows;
    private Set deletedRows;
    private List insertedRows;
    private int collectionSize;
    private RepeaterSorter sorter = null;
    private RepeaterFilter filter = null;
    private RepeaterAdapter adapter = null;
    private List itemsCache = new ArrayList();

    public void init(JXPathContext storageContext, String rowpath, RepeaterAdapter adapter) {
        this.storageContext = storageContext;
        this.collectionSize = 0;
        Object value = storageContext.getValue(rowpath);
        if (value != null) {
            this.collectionSize = value instanceof Collection ? ((Collection)value).size() : ((Double)storageContext.getValue("count(" + rowpath + ")")).intValue();
        }
        this.updatedRows = new HashMap();
        this.deletedRows = new HashSet();
        this.insertedRows = new ArrayList();
        this.adapter = adapter;
        this.sorter = adapter.sortBy(null);
    }

    private int getStartIndex(int start) {
        int i = start;
        RepeaterItem item = this.adapter.getItem(i);
        while (item == null && i > 0) {
            item = this.adapter.getItem(--i);
        }
        if (item == null) {
            return 0;
        }
        Iterator iter = this.deletedRows.iterator();
        while (iter.hasNext()) {
            RepeaterItem delitem = (RepeaterItem)iter.next();
            if (this.sorter.compare(delitem, item) >= 0) continue;
            ++i;
        }
        iter = this.insertedRows.iterator();
        while (iter.hasNext()) {
            RepeaterItem insitem = (RepeaterItem)iter.next();
            if (this.sorter.compare(insitem, item) >= 0) continue;
            --i;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    public List getItems(int start, int length) {
        RepeaterItem item;
        ArrayList<RepeaterItem> ret = new ArrayList<RepeaterItem>();
        int rlength = length;
        int rstart = this.getStartIndex(start);
        RepeaterItem startItem = null;
        if (rstart > 0) {
            startItem = this.getItem(rstart - 1);
        }
        if (startItem != null) {
            ret.add(startItem);
        }
        int i = rstart;
        while (length > 0 && (item = this.getItem(i)) != null) {
            while (this.isDeleted(item) && (item = this.getItem(++i)) != null) {
            }
            if (this.filter != null) {
                while (!this.filter.shouldDisplay(item) && (item = this.getItem(++i)) != null) {
                }
            }
            if (item == null) break;
            ret.add(item);
            ++i;
            --length;
        }
        if (this.insertedRows.size() > 0) {
            if (this.filter != null) {
                Iterator iter = this.insertedRows.iterator();
                while (iter.hasNext()) {
                    RepeaterItem acitem = (RepeaterItem)iter.next();
                    if (!this.filter.shouldDisplay(acitem)) continue;
                    ret.add(acitem);
                }
            } else {
                ret.addAll(this.insertedRows);
            }
            Collections.sort(ret, this.sorter);
        }
        if (startItem != null) {
            int pos = ret.indexOf(startItem);
            for (int j = 0; j <= pos; ++j) {
                ret.remove(0);
            }
        }
        while (ret.size() > rlength) {
            ret.remove(ret.size() - 1);
        }
        this.itemsCache.clear();
        this.itemsCache.addAll(ret);
        return ret;
    }

    public List getCachedItems() {
        return this.itemsCache;
    }

    public void flushCachedItems() {
        this.itemsCache.clear();
    }

    private RepeaterItem getItem(int i) {
        RepeaterItem item = this.adapter.getItem(i);
        if (item == null) {
            return null;
        }
        if (this.isUpdated(item)) {
            item = (RepeaterItem)this.updatedRows.get(item.getHandle());
        }
        return item;
    }

    public void updateRow(RepeaterItem item) {
        if (!this.isInserted(item) && !this.isDeleted(item)) {
            this.updatedRows.put(item.getHandle(), item);
        }
    }

    public void deleteRow(RepeaterItem item) {
        if (this.isInserted(item)) {
            this.insertedRows.remove(item);
            return;
        }
        if (this.isUpdated(item)) {
            this.updatedRows.remove(item);
        }
        this.deletedRows.add(item);
    }

    public void addRow(RepeaterItem item) {
        this.insertedRows.add(item);
    }

    public int getOriginalCollectionSize() {
        return this.collectionSize;
    }

    public int getActualCollectionSize() {
        return this.getOriginalCollectionSize() - this.deletedRows.size() + this.insertedRows.size();
    }

    private boolean isUpdated(RepeaterItem item) {
        return this.updatedRows.containsKey(item.getHandle());
    }

    private boolean isDeleted(RepeaterItem item) {
        return this.deletedRows.contains(item);
    }

    private boolean isInserted(RepeaterItem item) {
        return this.insertedRows.contains(item);
    }

    public JXPathContext getStorageContext() {
        return this.storageContext;
    }

    public List getDeletedRows() {
        ArrayList ret = new ArrayList(this.deletedRows);
        Collections.sort(ret, this.sorter);
        Collections.reverse(ret);
        return ret;
    }

    public List getInsertedRows() {
        return this.insertedRows;
    }

    public Collection getUpdatedRows() {
        return this.updatedRows.values();
    }

    public RepeaterAdapter getAdapter() {
        return this.adapter;
    }

    public void addRow(Repeater.RepeaterRow row) {
        RepeaterItem item = this.adapter.generateItem(row);
        this.addRow(item);
    }

    public void sortBy(String field) {
        this.sorter = this.adapter.sortBy(field);
    }

    public void filter(String field, Object value) {
        if (this.filter == null) {
            this.filter = this.adapter.getFilter();
        }
        this.filter.setFilter(field, value);
    }
}

