/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class RepeaterJXPathBinding
extends JXPathBindingBase {
    private final String repeaterId;
    private final String repeaterPath;
    private final String rowPath;
    private final String rowPathForInsert;
    private final JXPathBindingBase rowBinding;
    private final JXPathBindingBase insertRowBinding;
    private final JXPathBindingBase deleteRowBinding;
    private final ComposedJXPathBindingBase identityBinding;

    public RepeaterJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String repeaterId, String repeaterPath, String rowPath, String rowPathForInsert, JXPathBindingBase[] childBindings, JXPathBindingBase insertBinding, JXPathBindingBase[] deleteBindings, JXPathBindingBase[] identityBindings) {
        super(commonAtts);
        this.repeaterId = repeaterId;
        this.repeaterPath = repeaterPath;
        this.rowPath = rowPath;
        this.rowPathForInsert = rowPathForInsert;
        this.rowBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, childBindings);
        this.rowBinding.setParent(this);
        this.insertRowBinding = insertBinding;
        if (this.insertRowBinding != null) {
            this.insertRowBinding.setParent(this);
        }
        if (deleteBindings != null) {
            this.deleteRowBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, deleteBindings);
            this.deleteRowBinding.setParent(this);
        } else {
            this.deleteRowBinding = null;
        }
        if (identityBindings != null) {
            this.identityBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, identityBindings);
            this.identityBinding.setParent(this);
        } else {
            this.identityBinding = null;
        }
    }

    public String getId() {
        return this.repeaterId;
    }

    public String getRepeaterPath() {
        return this.repeaterPath;
    }

    public String getRowPath() {
        return this.rowPath;
    }

    public String getInsertRowPath() {
        return this.rowPathForInsert;
    }

    public ComposedJXPathBindingBase getRowBinding() {
        return (ComposedJXPathBindingBase)this.rowBinding;
    }

    public ComposedJXPathBindingBase getDeleteRowBinding() {
        return (ComposedJXPathBindingBase)this.deleteRowBinding;
    }

    public ComposedJXPathBindingBase getIdentityBinding() {
        return this.identityBinding;
    }

    public JXPathBindingBase getInsertRowBinding() {
        return this.insertRowBinding;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (repeater == null) {
            throw new BindingException("The repeater with the ID [" + this.repeaterId + "] referenced in the binding does not exist in the form definition.");
        }
        repeater.clear();
        Pointer ptr = jxpc.getPointer(this.repeaterPath);
        if (ptr.getNode() != null) {
            int initialSize = repeater.getSize();
            JXPathContext repeaterContext = jxpc.getRelativeContext(ptr);
            Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
            int currentRow = 0;
            while (rowPointers.hasNext()) {
                Repeater.RepeaterRow thisRow = currentRow < initialSize ? repeater.getRow(currentRow++) : repeater.addRow();
                Pointer jxp = (Pointer)rowPointers.next();
                JXPathContext rowContext = repeaterContext.getRelativeContext(jxp);
                if (this.identityBinding != null) {
                    this.identityBinding.loadFormFromModel((Widget)thisRow, rowContext);
                }
                this.rowBinding.loadFormFromModel((Widget)thisRow, rowContext);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done loading rows " + this));
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        JXPathContext repeaterContext = jxpc.getRelativeContext(jxpc.createPath(this.repeaterPath));
        HashSet<List> updatedRows = new HashSet<List>();
        ArrayList<Repeater.RepeaterRow> rowsToInsert = new ArrayList<Repeater.RepeaterRow>();
        int formRowCount = repeater.getSize();
        for (int i = 0; i < formRowCount; ++i) {
            Repeater.RepeaterRow thisRow = repeater.getRow(i);
            List identity = this.getIdentity(thisRow);
            if (this.hasNonNullElements(identity)) {
                Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
                boolean found = false;
                while (rowPointers.hasNext()) {
                    Pointer jxp = (Pointer)rowPointers.next();
                    JXPathContext rowContext = repeaterContext.getRelativeContext(jxp);
                    List contextIdentity = this.getIdentity(rowContext);
                    if (!ListUtils.isEqualList((Collection)identity, (Collection)contextIdentity)) continue;
                    this.rowBinding.saveFormToModel((Widget)thisRow, rowContext);
                    updatedRows.add(identity);
                    found = true;
                    break;
                }
                if (found) continue;
                rowsToInsert.add(thisRow);
                updatedRows.add(identity);
                continue;
            }
            rowsToInsert.add(thisRow);
        }
        Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
        ArrayList<JXPathContext> rowsToDelete = new ArrayList<JXPathContext>();
        while (rowPointers.hasNext()) {
            Pointer jxp = (Pointer)rowPointers.next();
            JXPathContext rowContext = repeaterContext.getRelativeContext((Pointer)jxp.clone());
            List contextIdentity = this.getIdentity(rowContext);
            if (this.isIdentityInUpdatedRows(updatedRows, contextIdentity)) continue;
            rowsToDelete.add(rowContext);
        }
        if (rowsToDelete.size() > 0) {
            for (int i = rowsToDelete.size() - 1; i >= 0; --i) {
                if (this.deleteRowBinding != null) {
                    this.deleteRowBinding.saveFormToModel(frmModel, rowsToDelete.get(i));
                    continue;
                }
                ((JXPathContext)rowsToDelete.get(i)).removePath(".");
            }
        }
        int indexCount = 1;
        rowPointers = repeaterContext.iteratePointers(this.rowPathForInsert);
        while (rowPointers.hasNext()) {
            rowPointers.next();
            ++indexCount;
        }
        if (rowsToInsert.size() > 0) {
            Iterator rowIterator = rowsToInsert.iterator();
            while (rowIterator.hasNext()) {
                Repeater.RepeaterRow thisRow = (Repeater.RepeaterRow)rowIterator.next();
                if (this.insertRowBinding != null) {
                    this.insertRowBinding.saveFormToModel((Widget)repeater, repeaterContext);
                }
                Pointer newRowContextPointer = repeaterContext.createPath(this.rowPathForInsert + "[" + indexCount + "]");
                JXPathContext newRowContext = repeaterContext.getRelativeContext(newRowContextPointer);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("inserted row at " + newRowContextPointer.asPath()));
                }
                this.rowBinding.saveFormToModel((Widget)thisRow, newRowContext);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"bound new row");
                }
                ++indexCount;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done saving rows " + this));
        }
    }

    private boolean isIdentityInUpdatedRows(Set identitySet, List identity) {
        Iterator iter = identitySet.iterator();
        while (iter.hasNext()) {
            List identityFromSet = (List)iter.next();
            if (!ListUtils.isEqualList((Collection)identityFromSet, (Collection)identity)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonNullElements(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return true;
        }
        return false;
    }

    private List getIdentity(JXPathContext rowContext) {
        if (this.identityBinding == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> identity = new ArrayList<Object>();
        JXPathBindingBase[] childBindings = this.identityBinding.getChildBindings();
        if (childBindings != null) {
            int size = childBindings.length;
            for (int i = 0; i < size; ++i) {
                ValueJXPathBinding vBinding = (ValueJXPathBinding)childBindings[i];
                Object value = rowContext.getValue(vBinding.getXPath());
                if (value != null && vBinding.getConvertor() != null) {
                    if (value instanceof String) {
                        ConversionResult conversionResult = vBinding.getConvertor().convertFromString((String)value, vBinding.getConvertorLocale(), null);
                        value = conversionResult.isSuccessful() ? conversionResult.getResult() : null;
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn((Object)"Convertor ignored on backend-value which isn't of type String.");
                    }
                }
                identity.add(value);
            }
        }
        return identity;
    }

    private List getIdentity(Repeater.RepeaterRow row) {
        if (this.identityBinding == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> identity = new ArrayList<Object>();
        JXPathBindingBase[] childBindings = this.identityBinding.getChildBindings();
        if (childBindings != null) {
            int size = childBindings.length;
            for (int i = 0; i < size; ++i) {
                String fieldId = ((ValueJXPathBinding)childBindings[i]).getFieldId();
                Widget widget = row.lookupWidget(fieldId);
                Object value = widget.getValue();
                identity.add(value);
            }
        }
        return identity;
    }

    public String toString() {
        return "RepeaterJXPathBinding [widget=" + this.repeaterId + ", xpath=" + this.repeaterPath + "]";
    }
}

