/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.EnhancedRepeaterJXPathBinding;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.RepeaterAdapter;
import org.apache.cocoon.forms.binding.RepeaterFilter;
import org.apache.cocoon.forms.binding.RepeaterItem;
import org.apache.cocoon.forms.binding.RepeaterJXPathCollection;
import org.apache.cocoon.forms.binding.RepeaterSorter;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class RepeaterJXPathAdapter
implements RepeaterAdapter {
    private int progressive = 100000;
    private EnhancedRepeaterJXPathBinding binding;
    private RepeaterJXPathCollection jxCollection;
    private List sortedItems;

    public RepeaterFilter getFilter() {
        return new RepeaterJXPathFilter();
    }

    private String findPathFor(String field) {
        JXPathBindingBase[] childBindings = this.binding.getRowBinding().getChildBindings();
        String path = null;
        for (int i = 0; i < childBindings.length; ++i) {
            ValueJXPathBinding bnd;
            if (!(childBindings[i] instanceof ValueJXPathBinding) || !(bnd = (ValueJXPathBinding)childBindings[i]).getFieldId().equals(field)) continue;
            path = bnd.getXPath();
            break;
        }
        return path;
    }

    public RepeaterSorter sortBy(String field) {
        if (field == null) {
            this.sortedItems = null;
            return new NormalOrderJXPathSorter();
        }
        String path = this.findPathFor(field);
        if (path == null) {
            throw new IllegalStateException("Cannot find a path for sorting on widget " + field);
        }
        RepeaterJXPathSorter sort = new RepeaterJXPathSorter(path, field);
        if (this.sortedItems == null) {
            ArrayList<RepeaterItem> tsortedItems = new ArrayList<RepeaterItem>();
            int i = 0;
            RepeaterItem item = this.getItem(i);
            while (item != null) {
                tsortedItems.add(item);
                item = this.getItem(++i);
            }
            this.sortedItems = tsortedItems;
        }
        Collections.sort(this.sortedItems, sort);
        return sort;
    }

    public void setBinding(EnhancedRepeaterJXPathBinding binding) {
        this.binding = binding;
    }

    public void setCollection(Collection c) {
    }

    public void setJXCollection(RepeaterJXPathCollection collection) {
        this.jxCollection = collection;
    }

    public RepeaterItem getItem(int i) {
        if (i < 0) {
            return null;
        }
        if (i >= this.jxCollection.getOriginalCollectionSize()) {
            return null;
        }
        if (this.sortedItems == null) {
            JXPathContext storageContext = this.jxCollection.getStorageContext();
            Pointer pointer = storageContext.getPointer(this.binding.getRowPath() + "[" + (i + 1) + "]");
            JXPathContext rowContext = storageContext.getRelativeContext(pointer);
            RepeaterItem item = new RepeaterItem(new Integer(i + 1));
            item.setContext(rowContext);
            return item;
        }
        return (RepeaterItem)this.sortedItems.get(i);
    }

    public RepeaterItem generateItem(Repeater.RepeaterRow row) {
        RepeaterItem item = new RepeaterItem(new Integer(this.progressive++));
        item.setRow(row);
        return item;
    }

    public void populateRow(RepeaterItem item) throws BindingException {
        this.binding.getRowBinding().loadFormFromModel((Widget)item.getRow(), item.getContext());
    }

    static class NormalOrderJXPathSorter
    implements RepeaterSorter {
        NormalOrderJXPathSorter() {
        }

        public void setCollection(Collection c) {
        }

        public int compare(Object o1, Object o2) {
            RepeaterItem i1 = (RepeaterItem)o1;
            RepeaterItem i2 = (RepeaterItem)o2;
            return ((Integer)i1.getHandle()).compareTo((Integer)i2.getHandle());
        }
    }

    static class RepeaterJXPathSorter
    implements RepeaterSorter {
        private String path;
        private String field;

        public RepeaterJXPathSorter(String path, String field) {
            this.path = path;
            this.field = field;
        }

        public void setCollection(Collection c) {
        }

        public int compare(Object o1, Object o2) {
            RepeaterItem i1 = (RepeaterItem)o1;
            RepeaterItem i2 = (RepeaterItem)o2;
            Object val1 = i1.getRow() != null ? i1.getRow().getChild(this.field).getValue() : i1.getContext().getValue(this.path);
            Object val2 = i2.getRow() != null ? i2.getRow().getChild(this.field).getValue() : i2.getContext().getValue(this.path);
            if (val1 instanceof Comparable) {
                return ((Comparable)val1).compareTo(val2);
            }
            return val1.toString().compareTo(val2.toString());
        }
    }

    class RepeaterJXPathFilter
    implements RepeaterFilter {
        private Map fieldsPaths = new HashMap();
        private Map fieldsValues = new HashMap();

        RepeaterJXPathFilter() {
        }

        public boolean shouldDisplay(RepeaterItem item) {
            Iterator iter = this.fieldsValues.keySet().iterator();
            if (iter.hasNext()) {
                String field = (String)iter.next();
                Object value = this.fieldsValues.get(field);
                Object acvalue = null;
                if (item.getRow() == null) {
                    String path = (String)this.fieldsPaths.get(field);
                    acvalue = item.getContext().getValue(path);
                } else {
                    acvalue = item.getRow().getChild(field).getValue();
                }
                if (acvalue == null) {
                    return false;
                }
                if (acvalue instanceof String && value instanceof String) {
                    return ((String)acvalue).startsWith((String)value);
                }
                return acvalue.equals(value);
            }
            return true;
        }

        public void setFilter(String field, Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                this.fieldsPaths.remove(field);
                this.fieldsValues.remove(field);
            } else {
                String path = RepeaterJXPathAdapter.this.findPathFor(field);
                if (path == null) {
                    throw new IllegalStateException("Cannot find a path for filtering on widget " + field);
                }
                this.fieldsPaths.put(field, path);
                this.fieldsValues.put(field, value);
            }
        }
    }
}

