/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class MultiValueJXPathBinding
extends JXPathBindingBase {
    private final String multiValueId;
    private final String multiValuePath;
    private final String rowPath;
    private final JXPathBindingBase updateBinding;
    private final Convertor convertor;
    private final Locale convertorLocale;

    public MultiValueJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String multiValueId, String multiValuePath, String rowPath, JXPathBindingBase[] updateBindings, Convertor convertor, Locale convertorLocale) {
        super(commonAtts);
        this.multiValueId = multiValueId;
        this.multiValuePath = multiValuePath;
        this.rowPath = rowPath;
        this.updateBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, updateBindings);
        this.convertor = convertor;
        this.convertorLocale = convertorLocale;
    }

    public String getId() {
        return this.multiValueId;
    }

    public String getMultiValuePath() {
        return this.multiValuePath;
    }

    public String getRowPath() {
        return this.rowPath;
    }

    public ComposedJXPathBindingBase getUpdateBinding() {
        return (ComposedJXPathBindingBase)this.updateBinding;
    }

    public Convertor getConvertor() {
        return this.convertor;
    }

    public Locale getLocale() {
        return this.convertorLocale;
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) throws BindingException {
        Widget widget = this.selectWidget(frmModel, this.multiValueId);
        if (widget == null) {
            throw new BindingException("The widget with the ID [" + this.multiValueId + "] referenced in the binding does not exist in the form definition.");
        }
        Pointer ptr = jctx.getPointer(this.multiValuePath);
        if (ptr.getNode() != null) {
            JXPathContext multiValueContext = jctx.getRelativeContext(ptr);
            Iterator rowPointers = multiValueContext.iterate(this.rowPath);
            LinkedList list = new LinkedList();
            while (rowPointers.hasNext()) {
                Object value = rowPointers.next();
                if (value != null && this.convertor != null) {
                    if (value instanceof String) {
                        ConversionResult conversionResult = this.convertor.convertFromString((String)value, this.convertorLocale, null);
                        value = conversionResult.isSuccessful() ? conversionResult.getResult() : null;
                    } else {
                        this.getLogger().warn((Object)"Convertor ignored on backend-value which isn't of type String.");
                    }
                }
                list.add(value);
            }
            widget.setValue(list.toArray());
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done loading values " + this));
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        Widget widget = this.selectWidget(frmModel, this.multiValueId);
        Object[] values = (Object[])widget.getValue();
        JXPathContext multiValueContext = jctx.getRelativeContext(jctx.createPath(this.multiValuePath));
        Iterator rowPointers = multiValueContext.iteratePointers(this.rowPath);
        int cnt = 0;
        while (rowPointers.hasNext()) {
            ++cnt;
            rowPointers.next();
        }
        while (cnt >= 1) {
            String thePath = this.rowPath + "[" + cnt + "]";
            multiValueContext.removePath(thePath);
            --cnt;
        }
        boolean update = false;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                String path = this.rowPath + '[' + (i + 1) + ']';
                Pointer rowPtr = multiValueContext.createPath(path);
                Object value = values[i];
                if (value != null && this.convertor != null) {
                    value = this.convertor.convertToString(value, this.convertorLocale, null);
                }
                rowPtr.setValue(value);
            }
            this.updateBinding.saveFormToModel(frmModel, multiValueContext);
            update = true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done saving " + this + " -- on-update == " + update));
        }
    }

    public String toString() {
        return "MultiValueJXPathBinding [widget=" + this.multiValueId + ", xpath=" + this.multiValuePath + "]";
    }
}

