/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.JavaScriptJXPathBinding;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;
import org.w3c.dom.Element;

public class JavaScriptJXPathBindingBuilder
extends JXPathBindingBuilderBase {
    private static Log LOG = LogFactory.getLog((Class)JavaScriptJXPathBindingBuilder.class);
    private ProcessInfoProvider processInfoProvider;

    public JXPathBindingBase buildBinding(Element element, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            Element[] children;
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(element);
            String id = DomHelper.getAttribute(element, "id", null);
            String path = DomHelper.getAttribute(element, "path", null);
            JavaScriptJXPathBinding otherBinding = (JavaScriptJXPathBinding)assistant.getContext().getSuperBinding();
            if (otherBinding != null) {
                commonAtts = JXPathBindingBuilderBase.mergeCommonAttributes(otherBinding.getCommonAtts(), commonAtts);
                if (id == null) {
                    id = otherBinding.getId();
                }
                if (path == null) {
                    path = otherBinding.getPath();
                }
            }
            Function loadScript = null;
            if (commonAtts.loadEnabled) {
                Element loadElem;
                if (otherBinding != null) {
                    loadScript = otherBinding.getLoadScript();
                }
                if ((loadElem = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#binding", "load-form")) != null) {
                    loadScript = JavaScriptHelper.buildFunction(loadElem, "loadForm", JavaScriptJXPathBinding.LOAD_PARAMS);
                }
            }
            Function saveScript = null;
            if (commonAtts.saveEnabled) {
                Element saveElem;
                if (otherBinding != null) {
                    saveScript = otherBinding.getSaveScript();
                }
                if ((saveElem = DomHelper.getChildElement(element, "http://apache.org/cocoon/forms/1.0#binding", "save-form")) != null) {
                    saveScript = JavaScriptHelper.buildFunction(saveElem, "saveForm", JavaScriptJXPathBinding.SAVE_PARAMS);
                }
            }
            HashMap childBindings = new HashMap();
            if (otherBinding != null) {
                Map otherChildren = otherBinding.getChildBindingsMap();
                Iterator it = otherChildren.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    childBindings.put(entry.getKey(), entry.getValue());
                }
            }
            if ((children = DomHelper.getChildElements(element, "http://apache.org/cocoon/forms/1.0#binding", "child-binding")).length != 0) {
                for (int i = 0; i < children.length; ++i) {
                    JXPathBindingBase[] bindings;
                    Element child = children[i];
                    String name = DomHelper.getAttribute(child, "name");
                    JXPathBindingBase[] otherBindings = null;
                    if (childBindings.containsKey(name)) {
                        otherBindings = ((ComposedJXPathBindingBase)childBindings.get(name)).getChildBindings();
                    }
                    if ((bindings = assistant.makeChildBindings(child, otherBindings)) == null) {
                        bindings = new JXPathBindingBase[]{};
                    }
                    ComposedJXPathBindingBase composedBinding = new ComposedJXPathBindingBase(commonAtts, bindings);
                    childBindings.put(name, composedBinding);
                }
            }
            JavaScriptJXPathBinding result = new JavaScriptJXPathBinding(this.processInfoProvider, commonAtts, id, path, loadScript, saveScript, Collections.unmodifiableMap(childBindings));
            return result;
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Cannot build binding", e, DomHelper.getLocationObject(element));
        }
    }

    public void setProcessInfoProvider(ProcessInfoProvider processInfoProvider) {
        this.processInfoProvider = processInfoProvider;
    }
}

