/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Map;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.lang.BooleanUtils;
import org.w3c.dom.Element;

public abstract class JXPathBindingBuilderBase
implements JXPathBindingBuilder {
    protected static CommonAttributes getCommonAttributes(Element bindingElm) throws BindingException {
        try {
            String location = DomHelper.getLocation(bindingElm);
            if (DomHelper.getAttributeAsBoolean(bindingElm, "readonly", false)) {
                throw new BindingException("Error in the binding.\nThe usage of the attribute @readonly has been deprecated in favour of @direction.", DomHelper.getLocationObject(bindingElm));
            }
            if (DomHelper.getAttributeAsBoolean(bindingElm, "read-only", false)) {
                throw new BindingException("Error in the binding.\nThe usage of the attribute @read-only has been deprecated in favour of @direction.", DomHelper.getLocationObject(bindingElm));
            }
            String direction = DomHelper.getAttribute(bindingElm, "direction", "both");
            String leniency = DomHelper.getAttribute(bindingElm, "lenient", null);
            Map nsDeclarationMap = DomHelper.getInheritedNSDeclarations(bindingElm);
            if (nsDeclarationMap != null && nsDeclarationMap.values().contains(null)) {
                throw new BindingException("Error in the binding.\nBinding doesn't support having namespace-declarations without explicit prefixes.", DomHelper.getLocationObject(bindingElm));
            }
            String jxPathFactoryName = bindingElm.getAttribute("jxpath-factory");
            AbstractFactory jxPathFactory = null;
            if (jxPathFactoryName != null && jxPathFactoryName.trim().length() > 0) {
                try {
                    Class<?> jxPathFactoryClass = JXPathBindingBuilderBase.class.getClassLoader().loadClass(jxPathFactoryName);
                    jxPathFactory = (AbstractFactory)jxPathFactoryClass.newInstance();
                }
                catch (Exception e) {
                    throw new BindingException("Error with specified jxpath factory " + jxPathFactoryName, e, DomHelper.getLocationObject(bindingElm));
                }
            }
            return new CommonAttributes(location, direction, leniency, nsDeclarationMap, jxPathFactory);
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building binding", e, DomHelper.getLocationObject(bindingElm));
        }
    }

    public static CommonAttributes mergeCommonAttributes(CommonAttributes existing, CommonAttributes extra) {
        if (extra == null) {
            return existing;
        }
        Boolean leniency = existing.leniency == null ? extra.leniency : existing.leniency;
        String strLeniency = null;
        if (leniency != null) {
            strLeniency = leniency.toString();
        }
        String direction = existing.direction;
        if (extra.direction != null) {
            direction = extra.direction;
        }
        AbstractFactory jxPathFactory = existing.jxPathFactory;
        if (extra.jxPathFactory != null) {
            jxPathFactory = extra.jxPathFactory;
        }
        return new CommonAttributes(extra.location, direction, strLeniency, extra.nsDeclarations, jxPathFactory);
    }

    public static class CommonAttributes {
        String direction = null;
        final String location;
        final boolean loadEnabled;
        final boolean saveEnabled;
        final Boolean leniency;
        final Map nsDeclarations;
        final AbstractFactory jxPathFactory;
        static final CommonAttributes DEFAULT = new CommonAttributes("location unknown", true, true, null, null, null);

        CommonAttributes(String location, String direction, String leniency, Map nsDeclarations, AbstractFactory jxPathFactory) {
            this(location, CommonAttributes.isLoadEnabled(direction), CommonAttributes.isSaveEnabled(direction), CommonAttributes.decideLeniency(leniency), nsDeclarations, jxPathFactory);
            this.direction = direction;
        }

        CommonAttributes(String location, boolean loadEnabled, boolean saveEnabled, Boolean leniency, Map nsDeclarations, AbstractFactory jxPathFactory) {
            this.location = location;
            this.loadEnabled = loadEnabled;
            this.saveEnabled = saveEnabled;
            this.leniency = leniency;
            this.nsDeclarations = nsDeclarations;
            this.jxPathFactory = jxPathFactory;
        }

        private static boolean isLoadEnabled(String direction) {
            return "both".equals(direction) || "load".equals(direction);
        }

        private static boolean isSaveEnabled(String direction) {
            return "both".equals(direction) || "save".equals(direction);
        }

        private static Boolean decideLeniency(String leniency) {
            return BooleanUtils.toBooleanObject((String)leniency);
        }
    }
}

