/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.lang.reflect.Method;
import org.apache.cocoon.forms.binding.AbstractCustomBinding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.CustomJXPathBinding;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.binding.JXPathBindingManager;
import org.apache.cocoon.forms.binding.ValueJXPathBinding;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.w3c.dom.Element;

public class CustomJXPathBindingBuilder
extends JXPathBindingBuilderBase
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private static Log LOG = LogFactory.getLog((Class)ValueJXPathBinding.class);
    private static final Class[] DOMELEMENT_METHODARGS = new Class[1];
    private static final Class[] EMPTY_METHODARGS;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public JXPathBindingBase buildBinding(Element bindingElm, JXPathBindingManager.Assistant assistant) throws BindingException {
        try {
            if (DomHelper.getAttribute(bindingElm, "class", null) != null) {
                throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(bindingElm) + ". Use a 'ref' attribute to address a Spring bean");
            }
            if (DomHelper.getAttribute(bindingElm, "builderclass", null) != null) {
                throw new RuntimeException("The 'builderclass' attribute is not supported anymore at " + DomHelper.getLocationObject(bindingElm) + ". Use a 'builderref' attribute to address a Spring bean");
            }
            JXPathBindingBuilderBase.CommonAttributes commonAtts = JXPathBindingBuilderBase.getCommonAttributes(bindingElm);
            String xpath = DomHelper.getAttribute(bindingElm, "path", ".");
            String widgetId = DomHelper.getAttribute(bindingElm, "id", null);
            Object bindingInstance = null;
            String beanRef = DomHelper.getAttribute(bindingElm, "ref", null);
            if (beanRef != null) {
                bindingInstance = this.beanFactory.getBean(beanRef);
            } else {
                String builderRefName = DomHelper.getAttribute(bindingElm, "builderref", null);
                String factoryMethodName = DomHelper.getAttribute(bindingElm, "factorymethod", null);
                Element configNode = DomHelper.getChildElement(bindingElm, "http://apache.org/cocoon/forms/1.0#binding", "config");
                if (builderRefName != null && factoryMethodName != null) {
                    Method factoryMethod;
                    Object builder = this.beanFactory.getBean(builderRefName);
                    Object[] args = null;
                    try {
                        factoryMethod = builder.getClass().getMethod(factoryMethodName, DOMELEMENT_METHODARGS);
                        args = new Object[]{configNode};
                    }
                    catch (NoSuchMethodException e) {
                        factoryMethod = null;
                    }
                    if (factoryMethod == null) {
                        factoryMethod = builder.getClass().getMethod(factoryMethodName, EMPTY_METHODARGS);
                        args = null;
                    }
                    bindingInstance = factoryMethod.invoke(null, args);
                }
            }
            CustomJXPathBinding otherBinding = (CustomJXPathBinding)assistant.getContext().getSuperBinding();
            if (otherBinding != null) {
                commonAtts = JXPathBindingBuilderBase.mergeCommonAttributes(otherBinding.getCommonAtts(), commonAtts);
                if (xpath == null) {
                    xpath = otherBinding.getXPath();
                }
                if (widgetId == null) {
                    widgetId = otherBinding.getId();
                }
                if (bindingInstance == null) {
                    bindingInstance = otherBinding.getWrappedBinding();
                }
            }
            CustomJXPathBinding customBinding = new CustomJXPathBinding(commonAtts, widgetId, xpath, (AbstractCustomBinding)bindingInstance);
            return customBinding;
        }
        catch (BindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Error building custom binding", e, DomHelper.getLocationObject(bindingElm));
        }
    }

    static {
        CustomJXPathBindingBuilder.DOMELEMENT_METHODARGS[0] = Element.class;
        EMPTY_METHODARGS = null;
    }
}

