/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.util.ClassUtils;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;

public class ContextJXPathBinding
extends ComposedJXPathBindingBase {
    private final String xpath;
    private AbstractFactory factory;

    public ContextJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String contextPath, JXPathBindingBase[] childBindings) {
        super(commonAtts, childBindings);
        this.xpath = contextPath;
    }

    public ContextJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String contextPath, String factoryClassName, JXPathBindingBase[] childBindings) {
        super(commonAtts, childBindings);
        this.xpath = contextPath;
        if (factoryClassName != null) {
            try {
                this.factory = (AbstractFactory)ClassUtils.newInstance((String)factoryClassName);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create an instance of " + factoryClassName, e);
            }
        }
    }

    public String getFactoryClassName() {
        return this.factory == null ? null : this.factory.getClass().getName();
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Pointer ptr = jxpc.getPointer(this.xpath);
        if (ptr.getNode() != null) {
            JXPathContext subContext = jxpc.getRelativeContext(ptr);
            super.doLoad(frmModel, subContext);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("done loading " + this));
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("non-existent path: skipping " + this));
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Pointer ptr;
        if (this.factory != null) {
            jxpc.setFactory(this.factory);
        }
        if ((ptr = jxpc.getPointer(this.xpath)).getNode() == null) {
            jxpc.createPath(this.xpath);
            ptr = jxpc.getPointer(this.xpath);
        }
        JXPathContext subContext = jxpc.getRelativeContext(ptr);
        super.doSave(frmModel, subContext);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("done saving " + this));
        }
    }

    public String getXPath() {
        return this.xpath;
    }

    public String toString() {
        return "ContextJXPathBinding [xpath=" + this.xpath + "]";
    }
}

