/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms;

import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.FormManager;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.FormDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DefaultFormManager
implements FormManager {
    private static final String PREFIX = "CocoonForms:";
    private static Log LOG = LogFactory.getLog((Class)DefaultFormManager.class);
    protected Map widgetDefinitionBuilders;
    protected CacheManager cacheManager;
    private Context avalonContext;
    private SourceResolver sourceResolver;
    private SAXParser parser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Form createForm(String uri) throws Exception {
        Form form;
        block4: {
            Source source = null;
            try {
                try {
                    source = this.sourceResolver.resolveURI(uri);
                }
                catch (Exception e) {
                    throw new FormsException("Could not resolve form definition URI.", e, (Location)new LocationImpl("[FormManager]", uri));
                }
                form = this.createForm(source);
                Object var5_5 = null;
                if (source == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (source == null) break block5;
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        return form;
    }

    public Form createForm(Source source) throws Exception {
        FormDefinition formDefinition = this.createFormDefinition(source);
        Form form = (Form)formDefinition.createInstance();
        form.initialize();
        return form;
    }

    public Form createForm(Element formElement) throws Exception {
        Form form = (Form)this.createFormDefinition(formElement).createInstance();
        form.initialize();
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormDefinition createFormDefinition(String uri) throws Exception {
        FormDefinition formDefinition;
        block4: {
            Source source = null;
            try {
                try {
                    source = this.sourceResolver.resolveURI(uri);
                }
                catch (Exception e) {
                    throw new FormsException("Could not resolve form definition.", e, (Location)new LocationImpl("[FormManager]", uri));
                }
                formDefinition = this.createFormDefinition(source);
                Object var5_5 = null;
                if (source == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_6 = null;
                    if (source == null) break block5;
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        return formDefinition;
    }

    public FormDefinition createFormDefinition(Source source) throws Exception {
        FormDefinition formDefinition = (FormDefinition)this.cacheManager.get(source, PREFIX);
        if (formDefinition != null && formDefinition.getLocalLibrary().dependenciesHaveChanged()) {
            formDefinition = null;
        }
        if (formDefinition == null) {
            Document formDocument;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Building Form: " + source.getURI()));
            }
            try {
                InputSource inputSource = new InputSource(source.getInputStream());
                inputSource.setSystemId(source.getURI());
                formDocument = DomHelper.parse(inputSource, this.parser);
            }
            catch (Exception e) {
                throw new FormsException("Could not parse form definition.", e, (Location)new LocationImpl("[FormManager]", source.getURI()));
            }
            Element formElement = formDocument.getDocumentElement();
            formDefinition = this.createFormDefinition(formElement);
            this.cacheManager.set(formDefinition, source, PREFIX);
        }
        return formDefinition;
    }

    public FormDefinition createFormDefinition(Element formElement) throws Exception {
        if (!"http://apache.org/cocoon/forms/1.0#definition".equals(formElement.getNamespaceURI()) || !formElement.getLocalName().equals("form")) {
            throw new FormsException("Expected forms definition <fd:form> element.", DomHelper.getLocationObject(formElement));
        }
        FormDefinitionBuilder builder = (FormDefinitionBuilder)this.widgetDefinitionBuilders.get("form");
        if (builder == null) {
            throw new Exception("Cannot find FormDefinitionBuilder 'form'");
        }
        return (FormDefinition)builder.buildWidgetDefinition(formElement);
    }

    public void setWidgetDefinitionBuilders(Map widgetDefinitionBuilders) {
        this.widgetDefinitionBuilders = widgetDefinitionBuilders;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public void setSourceResolver(SourceResolver sourceResolver) {
        this.sourceResolver = sourceResolver;
    }

    public void setAvalonContext(Context avalonContext) {
        this.avalonContext = avalonContext;
    }

    public Context getAvalonContext() {
        return this.avalonContext;
    }
}

