/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms;

import java.util.Map;
import org.apache.cocoon.forms.CacheManager;
import org.apache.commons.collections.FastHashMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;

public class DefaultCacheManager
implements CacheManager {
    protected Map cache = new FastHashMap();

    public Object get(Source source, String prefix) {
        String key = prefix + source.getURI();
        Object[] objectAndValidity = (Object[])this.cache.get(key);
        if (objectAndValidity == null) {
            return null;
        }
        SourceValidity validity = (SourceValidity)objectAndValidity[1];
        int valid = validity.isValid();
        if (valid == 0) {
            valid = validity.isValid(source.getValidity());
        }
        if (valid != 1) {
            this.cache.remove(key);
            return null;
        }
        return objectAndValidity[0];
    }

    public void set(Object object, Source source, String prefix) {
        SourceValidity validity = source.getValidity();
        if (validity != null) {
            String key = prefix + source.getURI();
            this.cache.put(key, new Object[]{object, validity});
        }
    }

    public void remove(Source source, String prefix) {
        String key = prefix + source.getURI();
        this.cache.remove(key);
    }
}

