/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class CompilingInterpreter
extends AbstractInterpreter {
    protected SourceResolver sourceresolver;
    protected final Map compiledScripts = new HashMap();

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.sourceresolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        Iterator i = this.compiledScripts.values().iterator();
        while (i.hasNext()) {
            ScriptSourceEntry entry = (ScriptSourceEntry)i.next();
            this.sourceresolver.release(entry.getSource());
        }
        this.compiledScripts.clear();
        if (this.manager != null) {
            this.manager.release((Object)this.sourceresolver);
            this.sourceresolver = null;
        }
        super.dispose();
    }

    protected abstract Script compileScript(Context var1, Scriptable var2, Source var3) throws Exception;

    protected class ScriptSourceEntry {
        private final Source source;
        private Script script;
        private long compileTime;

        public ScriptSourceEntry(Source source) {
            this.source = source;
        }

        public Source getSource() {
            return this.source;
        }

        public Script getScript() {
            return this.script;
        }

        public long getCompileTime() {
            return this.compileTime;
        }

        public void compile(Context context, Scriptable scope) throws Exception {
            if (this.script != null) {
                this.source.refresh();
            }
            if (this.script == null || this.compileTime < this.source.getLastModified()) {
                this.script = CompilingInterpreter.this.compileScript(context, scope, this.source);
                this.compileTime = this.source.getLastModified();
            }
        }
    }
}

