/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.sitemap;

import org.apache.cocoon.components.pipeline.ProcessingPipeline;

/**
 * Interface providing error handling capabilities to the pipeline
 *
 * @since 2.2
 * @version $Id: SitemapErrorHandler.java 587751 2007-10-24 02:41:36Z vgritsenko $
 */
public interface SitemapErrorHandler {

    /**
     * Handle an error.
     * @return true if error was handled.
     */
    public boolean handleError(Exception e) throws Exception;
    
    /**
     * Build error handling pipeline.
     * @return error handling pipeline, or null if error was not handled.
     */
    public ProcessingPipeline prepareErrorPipeline(Exception e) throws Exception;

}
