/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.pagination;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.pagination.PageRules;
import org.apache.cocoon.transformation.pagination.Pagesheet;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Paginator
extends AbstractTransformer
implements Serviceable,
Disposable,
CacheableProcessingComponent {
    public static final String PAGINATE_URI = "http://apache.org/cocoon/paginate/1.0";
    public static final String PAGINATE_PREFIX = "page";
    public static final String PAGINATE_PREFIX_TOKEN = "page:";
    private ServiceManager manager;
    private SAXParser parser;
    private Store store;
    private SourceResolver resolver;
    private Source inputSource;
    private int page;
    private int item;
    private String itemGroup;
    private String requestURI;
    private Request request;
    private Pagesheet pagesheet;
    private int level;
    private boolean prefixMapping;

    public void service(ServiceManager manager) throws ServiceException {
        try {
            this.manager = manager;
            this.getLogger().debug((Object)("Looking up " + SAXParser.ROLE));
            this.parser = (SAXParser)manager.lookup(SAXParser.ROLE);
            this.getLogger().debug((Object)("Looking up " + Store.TRANSIENT_STORE));
            this.store = (Store)manager.lookup(Store.TRANSIENT_STORE);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Could not find component", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.parser != null) {
            this.manager.release((Object)this.parser);
        } else {
            this.parser = null;
        }
        if (this.store != null) {
            this.manager.release((Object)this.store);
        } else {
            this.store = null;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        if (null == this.parser) {
            this.getLogger().debug((Object)("Looking up " + SAXParser.ROLE));
            try {
                this.parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            }
            catch (ServiceException e) {
                throw new ProcessingException("Could not lookup '" + SAXParser.ROLE + "'");
            }
        }
        if (src == null) {
            throw new ProcessingException("I need the paginate instructions (pagesheet) to continue. Set the 'src' attribute.");
        }
        try {
            this.level = 0;
            this.prefixMapping = false;
            this.resolver = resolver;
            this.inputSource = resolver.resolveURI(src);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Using pagesheet: '" + this.inputSource.getURI() + "' in " + (Object)((Object)this) + ", last modified: " + this.inputSource.getLastModified()));
            }
            this.page = par.getParameterAsInteger(PAGINATE_PREFIX, 1);
            this.item = par.getParameterAsInteger("item", 0);
            this.itemGroup = par.getParameter("item-group", "");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Paginating with [page = " + this.page + ", item = " + this.item + ", item-group = " + this.itemGroup + "]"));
            }
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.requestURI = this.request.getRequestURI();
            if (this.store != null) {
                this.pagesheet = (Pagesheet)this.store.get((Object)src);
            }
            if (this.pagesheet == null || this.pagesheet.modifiedSince(this.inputSource.getLastModified())) {
                this.pagesheet = new Pagesheet();
                this.pagesheet.setLastModified(this.inputSource.getLastModified());
                this.parser.parse(new InputSource(this.inputSource.getInputStream()), (ContentHandler)this.pagesheet);
                if (this.store != null) {
                    this.store.store((Object)src, (Object)this.pagesheet);
                }
            }
            this.pagesheet = (Pagesheet)this.pagesheet.clone();
        }
        catch (SourceException se) {
            throw new ProcessingException("Could not retrieve source '" + src + "'", (Throwable)se);
        }
    }

    public void recycle() {
        if (null != this.inputSource) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        super.recycle();
    }

    public Serializable getKey() {
        if (this.inputSource.getLastModified() != 0L) {
            return this.inputSource.getURI() + this.page;
        }
        return null;
    }

    public SourceValidity getValidity() {
        if (this.inputSource.getLastModified() != 0L) {
            AggregatedValidity validity = new AggregatedValidity();
            validity.add((SourceValidity)new TimeStampValidity((long)this.page));
            validity.add(this.inputSource.getValidity());
            return validity;
        }
        return null;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.prefixMapping) {
            super.startPrefixMapping(PAGINATE_PREFIX, PAGINATE_URI);
            this.prefixMapping = true;
        }
        ++this.level;
        this.pagesheet.processStartElement(uri, loc);
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            int itemCount = this.pagesheet.itemCount(uri, loc);
            if (itemCount > 0) {
                String itemGroup = this.pagesheet.getItemGroupName(uri, loc);
                AttributesImpl atts = new AttributesImpl(a);
                atts.addAttribute(PAGINATE_URI, "item", "page:item", "CDATA", String.valueOf(itemCount));
                atts.addAttribute(PAGINATE_URI, "item-group", "page:item-group", "CDATA", itemGroup);
                super.startElement(uri, loc, raw, (Attributes)atts);
            } else {
                super.startElement(uri, loc, raw, a);
            }
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        --this.level;
        if (PAGINATE_URI.equals(uri)) {
            super.endElement(uri, loc, raw);
            return;
        }
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            if (this.level == 0) {
                if (this.item == 0) {
                    int totalPages = this.pagesheet.getTotalPages();
                    PageRules rules = this.pagesheet.getPageRules(this.page);
                    Integer[] rangeLinks = rules.getRangeLinks();
                    int unitLinks = rules.unitLinks;
                    int currentPage = this.page;
                    Paginator.addPaginateTags(rangeLinks, unitLinks, currentPage, totalPages, this.requestURI, this);
                } else {
                    int totalItems = this.pagesheet.getTotalItems(this.itemGroup);
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "current", "current", "CDATA", String.valueOf(this.item));
                    atts.addAttribute("", "total", "total", "CDATA", String.valueOf(totalItems));
                    atts.addAttribute("", "current-uri", "current-uri", "CDATA", this.requestURI);
                    atts.addAttribute("", "clean-uri", "clean-uri", "CDATA", Paginator.cleanURI(this.requestURI, this.item));
                    atts.addAttribute("", PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(this.pagesheet.getPageForItem(this.item, this.itemGroup)));
                    super.startElement(PAGINATE_URI, "item", "page:item", (Attributes)atts);
                    if (this.item > 1) {
                        atts.clear();
                        atts.addAttribute("", "type", "type", "CDATA", "prev");
                        atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(this.requestURI, this.item, this.item - 1));
                        super.startElement(PAGINATE_URI, "link", "page:link", (Attributes)atts);
                        super.endElement(PAGINATE_URI, "link", "page:link");
                    }
                    if (this.item <= totalItems) {
                        atts.clear();
                        atts.addAttribute("", "type", "type", "CDATA", "next");
                        atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(this.requestURI, this.item, this.item + 1));
                        super.startElement(PAGINATE_URI, "link", "page:link", (Attributes)atts);
                        super.endElement(PAGINATE_URI, "link", "page:link");
                    }
                    super.endElement(PAGINATE_URI, "item", "page:item");
                }
                super.endPrefixMapping(PAGINATE_PREFIX);
            }
            super.endElement(uri, loc, raw);
        }
        this.pagesheet.processEndElement(uri, loc);
    }

    public static void addPaginateTags(Integer[] rangeLinks, int unitLinks, int currentPage, int totalPages, String requestURI, AbstractTransformer saxTransformer) throws SAXException {
        int rangeLink;
        int i;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "current", "current", "CDATA", String.valueOf(currentPage));
        atts.addAttribute("", "total", "total", "CDATA", String.valueOf(totalPages));
        atts.addAttribute("", "current-uri", "current-uri", "CDATA", requestURI);
        atts.addAttribute("", "clean-uri", "clean-uri", "CDATA", Paginator.cleanURI(requestURI, currentPage));
        saxTransformer.startElement(PAGINATE_URI, PAGINATE_PREFIX, "page:page", (Attributes)atts);
        for (i = rangeLinks.length - 1; i > -1; --i) {
            rangeLink = rangeLinks[i];
            if (rangeLink <= 0 || currentPage - rangeLink < 1) continue;
            atts.clear();
            atts.addAttribute("", "type", "type", "CDATA", "prev");
            atts.addAttribute("", "range", "range", "CDATA", rangeLinks[i].toString());
            atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, currentPage - rangeLink));
            atts.addAttribute("", PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(currentPage - rangeLink));
            saxTransformer.startElement(PAGINATE_URI, "range-link", "page:range-link", (Attributes)atts);
            saxTransformer.endElement(PAGINATE_URI, "range-link", "page:range-link");
        }
        for (i = currentPage - unitLinks; i < currentPage; ++i) {
            if (i <= 0) continue;
            atts.clear();
            atts.addAttribute("", "type", "type", "CDATA", "prev");
            atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, i));
            atts.addAttribute("", PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(i));
            saxTransformer.startElement(PAGINATE_URI, "link", "page:link", (Attributes)atts);
            saxTransformer.endElement(PAGINATE_URI, "link", "page:link");
        }
        for (i = currentPage + 1; i <= currentPage + unitLinks; ++i) {
            if (i > totalPages) continue;
            atts.clear();
            atts.addAttribute("", "type", "type", "CDATA", "next");
            atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, i));
            atts.addAttribute("", PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(i));
            saxTransformer.startElement(PAGINATE_URI, "link", "page:link", (Attributes)atts);
            saxTransformer.endElement(PAGINATE_URI, "link", "page:link");
        }
        for (i = 0; i < rangeLinks.length; ++i) {
            rangeLink = rangeLinks[i];
            if (rangeLink <= 0 || currentPage + rangeLink > totalPages) continue;
            atts.clear();
            atts.addAttribute("", "type", "type", "CDATA", "next");
            atts.addAttribute("", "range", "range", "CDATA", rangeLinks[i].toString());
            atts.addAttribute("", "uri", "uri", "CDATA", Paginator.encodeURI(requestURI, currentPage, currentPage + rangeLink));
            atts.addAttribute("", PAGINATE_PREFIX, PAGINATE_PREFIX, "CDATA", String.valueOf(currentPage + rangeLink));
            saxTransformer.startElement(PAGINATE_URI, "range-link", "page:range-link", (Attributes)atts);
            saxTransformer.endElement(PAGINATE_URI, "range-link", "page:range-link");
        }
        saxTransformer.endElement(PAGINATE_URI, PAGINATE_PREFIX, "page:page");
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.pagesheet.processCharacters(c, start, len);
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (!this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            throw new SAXException("Recieved startDTD not in page.");
        }
        super.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (!this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            throw new SAXException("Recieved endDTD not in page.");
        }
        super.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.pagesheet.isInPage(this.page, this.item, this.itemGroup)) {
            super.comment(ch, start, len);
        }
    }

    public static String cleanURI(String uri, int current) {
        String currentS = String.valueOf(current);
        int index = uri.lastIndexOf(currentS);
        if (index == -1) {
            return uri;
        }
        return uri.substring(0, index - 1) + uri.substring(index + currentS.length() + 1);
    }

    public static String encodeURI(String uri, int current, int next) {
        String currentS = String.valueOf(current);
        String nextS = String.valueOf(next);
        int index = uri.lastIndexOf(currentS);
        if (index == -1) {
            index = uri.lastIndexOf(46);
            if (index == -1) {
                return uri + "(" + nextS + ")";
            }
            return uri.substring(0, index) + "(" + nextS + ")." + uri.substring(index + 1);
        }
        return uri.substring(0, index) + nextS + uri.substring(index + currentS.length());
    }

    public ServiceManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceManager manager) {
        this.manager = manager;
    }
}

