/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.xslt.TraxErrorListener;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.components.xslt.XSLTProcessorException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.avalon.CLLoggerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLTTransformer
extends AbstractTransformer
implements Serviceable,
Configurable,
CacheableProcessingComponent,
Disposable {
    protected ServiceManager manager;
    protected Map objectModel;
    protected Map logicSheetParameters;
    private boolean useParameters = false;
    private boolean _useParameters = false;
    private boolean useCookies = false;
    private boolean _useCookies = false;
    private boolean useSessionInfo = false;
    private boolean _useSessionInfo = false;
    private boolean checkIncludes = true;
    protected TransformerHandler transformerHandler;
    protected SourceValidity transformerValidity;
    private Source inputSource;
    private Parameters par;
    private SourceResolver resolver;
    private String defaultSrc;
    private XSLTProcessor xsltProcessor;
    private boolean finishedDocument = false;
    private Method xalanDtmManagerGetIncrementalMethod;
    private SAXException exceptionDuringSetConsumer;
    private TraxErrorListener errorListener;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration child = conf.getChild("use-request-parameters");
        this._useParameters = this.useParameters = child.getValueAsBoolean(false);
        child = conf.getChild("use-cookies");
        this._useCookies = this.useCookies = child.getValueAsBoolean(false);
        child = conf.getChild("use-session-info");
        this._useSessionInfo = this.useSessionInfo = child.getValueAsBoolean(false);
        child = conf.getChild("xslt-processor-role");
        String xsltProcessorRole = child.getValue(XSLTProcessor.class.getName());
        if (!xsltProcessorRole.startsWith(XSLTProcessor.class.getName())) {
            xsltProcessorRole = XSLTProcessor.class.getName() + '/' + xsltProcessorRole;
        }
        child = conf.getChild("check-includes");
        this.checkIncludes = child.getValueAsBoolean(this.checkIncludes);
        child = conf.getChild("default-src", false);
        if (child != null) {
            this.defaultSrc = child.getValue();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Use parameters is " + this.useParameters));
            this.getLogger().debug((Object)("Use cookies is " + this.useCookies));
            this.getLogger().debug((Object)("Use session info is " + this.useSessionInfo));
            this.getLogger().debug((Object)("Use TrAX Processor " + xsltProcessorRole));
            this.getLogger().debug((Object)("Check for included stylesheets is " + this.checkIncludes));
            this.getLogger().debug((Object)("Default source = " + this.defaultSrc));
        }
        try {
            this.xsltProcessor = (XSLTProcessor)this.manager.lookup(xsltProcessorRole);
        }
        catch (ServiceException e) {
            throw new ConfigurationException("Cannot load XSLT processor", (Throwable)e);
        }
        try {
            Class<?> dtmManagerClass = Class.forName("org.apache.xml.dtm.DTMManager");
            this.xalanDtmManagerGetIncrementalMethod = dtmManagerClass.getMethod("getIncremental", null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Was not able to get getIncremental method from Xalan's DTMManager.", (Throwable)e);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws SAXException, ProcessingException, IOException {
        if (src == null && this.defaultSrc != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("src is null, using default source " + this.defaultSrc));
            }
            src = this.defaultSrc;
        }
        if (src == null) {
            throw new ProcessingException("Stylesheet URI can't be null");
        }
        this.par = par;
        this.objectModel = objectModel;
        this.resolver = resolver;
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Unable to resolve " + src), (SourceException)se);
        }
        this._useParameters = par.getParameterAsBoolean("use-request-parameters", this.useParameters);
        this._useCookies = par.getParameterAsBoolean("use-cookies", this.useCookies);
        this._useSessionInfo = par.getParameterAsBoolean("use-session-info", this.useSessionInfo);
        boolean _checkIncludes = par.getParameterAsBoolean("check-includes", this.checkIncludes);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Using stylesheet: '" + this.inputSource.getURI() + "' in " + (Object)((Object)this)));
            this.getLogger().debug((Object)("Use parameters is " + this._useParameters));
            this.getLogger().debug((Object)("Use cookies is " + this._useCookies));
            this.getLogger().debug((Object)("Use session info is " + this._useSessionInfo));
            this.getLogger().debug((Object)("Check for included stylesheets is " + _checkIncludes));
        }
        try {
            if (_checkIncludes) {
                XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity = this.xsltProcessor.getTransformerHandlerAndValidity(this.inputSource, null);
                this.transformerHandler = handlerAndValidity.getTransfomerHandler();
                this.transformerValidity = handlerAndValidity.getTransfomerValidity();
            } else {
                this.transformerValidity = this.inputSource.getValidity();
            }
        }
        catch (XSLTProcessorException se) {
            throw new ProcessingException("Unable to get transformer handler for " + this.inputSource.getURI(), (Throwable)se);
        }
    }

    public Serializable getKey() {
        Map map = this.getLogicSheetParameters();
        if (map == null) {
            return this.inputSource.getURI();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.inputSource.getURI());
        Set entries = map.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            sb.append(';');
            Map.Entry entry = i.next();
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public SourceValidity getValidity() {
        return this.transformerValidity;
    }

    public void setConsumer(XMLConsumer consumer) {
        Map map;
        if (this.transformerHandler == null) {
            try {
                this.transformerHandler = this.xsltProcessor.getTransformerHandler(this.inputSource);
            }
            catch (XSLTProcessorException se) {
                this.exceptionDuringSetConsumer = new SAXException("Unable to get transformer handler for " + this.inputSource.getURI(), se);
                return;
            }
        }
        if ((map = this.getLogicSheetParameters()) != null) {
            Transformer transformer = this.transformerHandler.getTransformer();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        super.setContentHandler((ContentHandler)this.transformerHandler);
        super.setLexicalHandler((LexicalHandler)this.transformerHandler);
        if (this.transformerHandler instanceof LogEnabled) {
            ((LogEnabled)this.transformerHandler).enableLogging((Logger)new CLLoggerWrapper(this.getLogger()));
        }
        SAXResult result = new SAXResult((ContentHandler)consumer);
        result.setLexicalHandler((LexicalHandler)consumer);
        this.transformerHandler.setResult(result);
        this.errorListener = new TraxErrorListener(this.inputSource.getURI());
        this.transformerHandler.getTransformer().setErrorListener(this.errorListener);
    }

    protected Map getLogicSheetParameters() {
        Cookie[] cookies;
        Request request;
        Enumeration parameters;
        String value;
        String name;
        String[] params;
        if (this.logicSheetParameters != null) {
            return this.logicSheetParameters;
        }
        HashMap<String, String> map = null;
        if (this.par != null && (params = this.par.getNames()) != null) {
            for (int i = 0; i < params.length; ++i) {
                name = params[i];
                if (!XSLTTransformer.isValidXSLTParameterName(name) || (value = this.par.getParameter(name, null)) == null) continue;
                if (map == null) {
                    map = new HashMap(params.length);
                }
                map.put(name, value);
            }
        }
        if (this._useParameters && (parameters = (request = ObjectModelHelper.getRequest((Map)this.objectModel)).getParameterNames()) != null) {
            while (parameters.hasMoreElements()) {
                name = (String)parameters.nextElement();
                if (!XSLTTransformer.isValidXSLTParameterName(name)) continue;
                value = request.getParameter(name);
                if (map == null) {
                    map = new HashMap();
                }
                map.put(name, value);
            }
        }
        if (this._useSessionInfo) {
            HttpSession session;
            request = ObjectModelHelper.getRequest((Map)this.objectModel);
            if (map == null) {
                map = new HashMap<String, String>(6);
            }
            if ((session = request.getSession(false)) != null) {
                map.put("session-available", "true");
                map.put("session-is-new", BooleanUtils.toStringTrueFalse((boolean)session.isNew()));
                map.put("session-id-from-cookie", BooleanUtils.toStringTrueFalse((boolean)request.isRequestedSessionIdFromCookie()));
                map.put("session-id-from-url", BooleanUtils.toStringTrueFalse((boolean)request.isRequestedSessionIdFromURL()));
                map.put("session-valid", BooleanUtils.toStringTrueFalse((boolean)request.isRequestedSessionIdValid()));
                map.put("session-id", session.getId());
            } else {
                map.put("session-available", "false");
            }
        }
        if (this._useCookies && (cookies = (request = ObjectModelHelper.getRequest((Map)this.objectModel)).getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String name2 = cookies[i].getName();
                if (!XSLTTransformer.isValidXSLTParameterName(name2)) continue;
                String value2 = cookies[i].getValue();
                if (map == null) {
                    map = new HashMap(cookies.length);
                }
                map.put(name2, value2);
            }
        }
        this.logicSheetParameters = map;
        return this.logicSheetParameters;
    }

    static boolean isValidXSLTParameterName(String name) {
        if (name.length() == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = name.length() - 1; i > 1; --i) {
            c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.xsltProcessor);
            this.xsltProcessor = null;
            this.manager = null;
        }
    }

    public void recycle() {
        this.objectModel = null;
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        this.par = null;
        if (!this.finishedDocument && this.transformerHandler != null && this.xalanDtmManagerGetIncrementalMethod != null && this.transformerHandler.getClass().getName().equals("org.apache.xalan.transformer.TransformerHandlerImpl")) {
            try {
                boolean incremental = (Boolean)this.xalanDtmManagerGetIncrementalMethod.invoke(null, null);
                if (incremental) {
                    super.endDocument();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.finishedDocument = true;
        this.logicSheetParameters = null;
        this.transformerHandler = null;
        this.transformerValidity = null;
        this.exceptionDuringSetConsumer = null;
        this.errorListener = null;
        super.recycle();
    }

    public void endDocument() throws SAXException {
        try {
            super.endDocument();
        }
        catch (Exception e) {
            Throwable realEx = this.errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof SAXException) {
                throw (SAXException)realEx;
            }
            if (realEx instanceof Error) {
                throw (Error)realEx;
            }
            throw new NestableRuntimeException(realEx);
        }
        this.finishedDocument = true;
    }

    public void startDocument() throws SAXException {
        if (this.exceptionDuringSetConsumer != null) {
            throw this.exceptionDuringSetConsumer;
        }
        this.finishedDocument = false;
        super.startDocument();
    }
}

