/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.Serializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.SAXException;

public class FragmentExtractorGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    public Serializable getKey() {
        return this.source;
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void generate() throws SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Retrieving fragment " + this.source + "."));
        }
        Store store = null;
        Object fragment = null;
        try {
            store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
            fragment = store.get((Object)this.source);
            if (fragment == null) {
                throw new ResourceNotFoundException("Could not find fragment " + this.source + " in store");
            }
            XMLByteStreamInterpreter deserializer = new XMLByteStreamInterpreter();
            deserializer.setConsumer(this.xmlConsumer);
            deserializer.deserialize(fragment);
        }
        catch (ServiceException ce) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Could not lookup for component.", (Throwable)ce);
            }
            throw new SAXException("Could not lookup for component.", (Exception)((Object)ce));
        }
        finally {
            this.manager.release((Object)store);
        }
    }
}

