/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.location.LocatableException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.cocoon.util.location.MultiLocatable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExceptionGenerator
extends AbstractGenerator {
    public static final String EXCEPTION_NS = "http://apache.org/cocoon/exception/1.0";
    private Throwable thr;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.thr = ObjectModelHelper.getThrowable((Map)objectModel);
        if (this.thr == null) {
            throw new ProcessingException("ExceptionGenerator should be used in <map:handle-errors>");
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        ExceptionGenerator.toSAX(this.thr, this.contentHandler);
        this.contentHandler.endDocument();
    }

    public static void toSAX(Throwable thr, ContentHandler handler) throws SAXException {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)thr);
        if (cause == null) {
            cause = thr;
        }
        AttributesImpl attr = new AttributesImpl();
        handler.startPrefixMapping("ex", EXCEPTION_NS);
        attr.addCDATAAttribute("class", cause.getClass().getName());
        handler.startElement(EXCEPTION_NS, "exception-report", "ex:exception-report", (Attributes)attr);
        Location loc = LocationUtils.getLocation((Object)cause);
        if (LocationUtils.isKnown((Location)loc)) {
            attr.clear();
            ExceptionGenerator.dumpLocation(loc, attr, handler);
        }
        attr.clear();
        String message = cause instanceof LocatableException ? ((LocatableException)cause).getRawMessage() : cause.getMessage();
        ExceptionGenerator.simpleElement("message", (Attributes)attr, message, handler);
        Throwable current = thr;
        while (current != null) {
            handler.startElement(EXCEPTION_NS, "content", "ex:content", (Attributes)attr);
            if (current instanceof XMLizable) {
                ((XMLizable)current).toSAX(handler);
            }
            handler.endElement(EXCEPTION_NS, "content", "ex:content");
            current = ExceptionUtils.getCause((Throwable)current);
        }
        handler.startElement(EXCEPTION_NS, "cocoon-stacktrace", "ex:cocoon-stacktrace", (Attributes)attr);
        current = thr;
        while (current != null) {
            loc = LocationUtils.getLocation((Object)current);
            if (LocationUtils.isKnown((Location)loc)) {
                handler.startElement(EXCEPTION_NS, "exception", "ex:exception", (Attributes)attr);
                message = current instanceof LocatableException ? ((LocatableException)current).getRawMessage() : current.getMessage();
                ExceptionGenerator.simpleElement("message", (Attributes)attr, message, handler);
                attr.clear();
                handler.startElement(EXCEPTION_NS, "locations", "ex:locations", (Attributes)attr);
                ExceptionGenerator.dumpLocation(loc, attr, handler);
                if (current instanceof MultiLocatable) {
                    List locations = ((MultiLocatable)current).getLocations();
                    for (int i = 1; i < locations.size(); ++i) {
                        attr.clear();
                        ExceptionGenerator.dumpLocation((Location)locations.get(i), attr, handler);
                    }
                }
                handler.endElement(EXCEPTION_NS, "locations", "ex:locations");
                handler.endElement(EXCEPTION_NS, "exception", "ex:exception");
            }
            current = ExceptionUtils.getCause((Throwable)current);
        }
        handler.endElement(EXCEPTION_NS, "cocoon-stacktrace", "ex:cocoon-stacktrace");
        attr.clear();
        ExceptionGenerator.simpleElement("stacktrace", (Attributes)attr, ExceptionUtils.getStackTrace((Throwable)cause), handler);
        if (thr != cause) {
            String trace = SystemUtils.isJavaVersionAtLeast((int)140) ? ExceptionUtils.getStackTrace((Throwable)thr) : ExceptionUtils.getFullStackTrace((Throwable)thr);
            ExceptionGenerator.simpleElement("full-stacktrace", (Attributes)attr, trace, handler);
        }
        handler.endElement(EXCEPTION_NS, "exception-report", "ex:exception-report");
        handler.endPrefixMapping("ex");
    }

    private static void dumpLocation(Location loc, AttributesImpl attr, ContentHandler handler) throws SAXException {
        attr.addCDATAAttribute("uri", loc.getURI());
        attr.addCDATAAttribute("line", Integer.toString(loc.getLineNumber()));
        attr.addCDATAAttribute("column", Integer.toString(loc.getColumnNumber()));
        ExceptionGenerator.simpleElement("location", (Attributes)attr, loc.getDescription(), handler);
    }

    private static void simpleElement(String name, Attributes attr, String value, ContentHandler handler) throws SAXException {
        handler.startElement(EXCEPTION_NS, name, "ex:" + name, attr);
        if (value != null && value.length() > 0) {
            handler.characters(value.toCharArray(), 0, value.length());
        }
        handler.endElement(EXCEPTION_NS, name, "ex:" + name);
    }
}

