/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import org.apache.cocoon.util.AbstractLogEnabled;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LoggingContentHandler
extends AbstractLogEnabled
implements ContentHandler {
    String id;
    ContentHandler contentHandler;

    public LoggingContentHandler(String id, ContentHandler contentHandler) {
        this.id = id;
        this.contentHandler = contentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.log("setDocumentLocator", "");
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.log("startDocument", "");
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.log("endDocument", "");
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.log("startPrefixMapping", "prefix=" + prefix + ",uri=" + uri);
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.log("endPrefixMapping", "prefix=" + prefix);
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.log("startElement", "uri=" + uri + ",local=" + loc + ",raw=" + raw);
        for (int i = 0; i < a.getLength(); ++i) {
            this.log("            ", Integer.toString(i + 1) + ". uri=" + a.getURI(i) + ",local=" + a.getLocalName(i) + ",qname=" + a.getQName(i) + ",type=" + a.getType(i) + ",value=" + a.getValue(i));
        }
        this.contentHandler.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String qname) throws SAXException {
        this.log("endElement", "uri=" + uri + ",local=" + loc + ",qname=" + qname);
        this.contentHandler.endElement(uri, loc, qname);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.log("characters", new String(ch, start, len));
        this.contentHandler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.log("ignorableWhitespace", new String(ch, start, len));
        this.contentHandler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.log("processingInstruction", "target=" + target + ",data=" + data);
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.log("skippedEntity", "name=" + name);
        this.contentHandler.skippedEntity(name);
    }

    private void log(String location, String description) {
        this.getLogger().debug((Object)(this.id + "[" + location + "] " + description + "\n"));
    }
}

