/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.commons.logging.Log;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.xml.sax.ContentHandler;

public final class PreemptiveLoader
extends AbstractLogEnabled {
    private static final PreemptiveLoader INSTANCE = new PreemptiveLoader();
    private Map cacheStorageProxyMap = new HashMap(20);
    private List loadList = new ArrayList(50);
    boolean alive;

    static PreemptiveLoader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IncludeCacheStorageProxy proxy, String uri, long expires) {
        Object object;
        boolean addItem = true;
        ArrayList<String> uriList = (ArrayList<String>)this.cacheStorageProxyMap.get(proxy);
        if (null == uriList) {
            uriList = new ArrayList<String>(50);
            this.cacheStorageProxyMap.put(proxy, uriList);
        } else {
            object = uriList;
            synchronized (object) {
                if (uriList.contains(uri)) {
                    addItem = false;
                }
            }
        }
        if (addItem) {
            uriList.add(uri);
            this.loadList.add(new Object[]{proxy, uri, new Long(expires), uriList});
        }
        object = this.cacheStorageProxyMap;
        synchronized (object) {
            this.cacheStorageProxyMap.notify();
        }
    }

    public void process(SourceResolver resolver) {
        this.process(resolver, this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process(SourceResolver resolver, Log logger) {
        this.alive = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PreemptiveLoader: Starting preemptive loading");
        }
        while (this.alive) {
            while (this.loadList.size() > 0) {
                Object[] object = (Object[])this.loadList.get(0);
                String uri = (String)object[1];
                this.loadList.remove(0);
                Object object2 = object[3];
                synchronized (object2) {
                    ((List)object[3]).remove(uri);
                }
                Source source = null;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("PreemptiveLoader: Loading " + uri));
                    }
                    source = resolver.resolveURI(uri);
                    XMLByteStreamCompiler serializer = new XMLByteStreamCompiler();
                    SourceUtil.toSAX(source, (ContentHandler)serializer);
                    SourceValidity[] validities = new SourceValidity[]{new ExpiresValidity((Long)object[2] * 1000L)};
                    CachedResponse response = new CachedResponse(validities, (byte[])serializer.getSAXFragment());
                    ((IncludeCacheStorageProxy)object[0]).put(uri, (Serializable)response);
                }
                catch (Exception ignore) {
                    resolver.release(source);
                    catch (Throwable throwable) {
                        resolver.release(source);
                        throw throwable;
                    }
                }
                resolver.release(source);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("PreemptiveLoader: Finished loading " + uri));
            }
            Map map = this.cacheStorageProxyMap;
            synchronized (map) {
                try {
                    this.cacheStorageProxyMap.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PreemptiveLoader: Finished preemptive loading");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.alive = false;
        Map map = this.cacheStorageProxyMap;
        synchronized (map) {
            this.cacheStorageProxyMap.notify();
        }
    }
}

