/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.File;
import org.apache.cocoon.configuration.Settings;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;

public class MultipartConfigurationHelper {
    public static final boolean ENABLE_UPLOADS = false;
    public static final boolean SAVE_UPLOADS_TO_DISK = true;
    public static final int MAX_UPLOAD_SIZE = 10000000;
    String KEY_UPLOADS_DIRECTORY = "org.apache.cocoon.uploads.directory";
    String KEY_UPLOADS_ENABLE = "org.apache.cocoon.uploads.enable";
    String KEY_UPLOADS_AUTOSAVE = "org.apache.cocoon.uploads.autosave";
    String KEY_UPLOADS_OVERWRITE = "org.apache.cocoon.uploads.overwrite";
    String KEY_UPLOADS_MAXSIZE = "org.apache.cocoon.uploads.maxsize";
    protected boolean enableUploads = false;
    protected String uploadDirectory;
    protected boolean autosaveUploads = true;
    protected String overwriteUploads;
    protected int maxUploadSize = 10000000;

    public void configure(Settings settings, Log logger) {
        File uploadDir;
        String uploadDirParam;
        String value = settings.getProperty(this.KEY_UPLOADS_ENABLE);
        if (value != null) {
            this.setEnableUploads(BooleanUtils.toBoolean((String)value));
        }
        if ((value = settings.getProperty(this.KEY_UPLOADS_DIRECTORY)) != null) {
            this.setUploadDirectory(value);
        }
        if ((value = settings.getProperty(this.KEY_UPLOADS_AUTOSAVE)) != null) {
            this.setAutosaveUploads(BooleanUtils.toBoolean((String)value));
        }
        if ((value = settings.getProperty(this.KEY_UPLOADS_OVERWRITE)) != null) {
            this.setOverwriteUploads(value);
        }
        if ((value = settings.getProperty(this.KEY_UPLOADS_MAXSIZE)) != null) {
            this.setMaxUploadSize(Integer.valueOf(value));
        }
        if ((uploadDirParam = this.getUploadDirectory()) != null) {
            uploadDir = new File(uploadDirParam);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using upload-directory " + uploadDir));
            }
        } else {
            uploadDir = new File(settings.getWorkDirectory(), "upload-dir" + File.separator);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using default upload-directory " + uploadDir));
            }
        }
        uploadDir.mkdirs();
        this.setUploadDirectory(uploadDir.getAbsolutePath());
    }

    public boolean isAutosaveUploads() {
        return this.autosaveUploads;
    }

    public boolean isEnableUploads() {
        return this.enableUploads;
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public String getOverwriteUploads() {
        return this.overwriteUploads;
    }

    public String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public boolean isAllowOverwrite() {
        String value = this.getOverwriteUploads();
        if ("deny".equalsIgnoreCase(value)) {
            return false;
        }
        return "allow".equalsIgnoreCase(value);
    }

    public boolean isSilentlyRename() {
        String value = this.getOverwriteUploads();
        if ("deny".equalsIgnoreCase(value)) {
            return false;
        }
        return !"allow".equalsIgnoreCase(value);
    }

    public void setAutosaveUploads(boolean autosaveUploadsValue) {
        this.autosaveUploads = autosaveUploadsValue;
    }

    public void setEnableUploads(boolean enableUploads) {
        this.enableUploads = enableUploads;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public void setOverwriteUploads(String overwriteUploads) {
        this.overwriteUploads = overwriteUploads;
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory;
    }
}

