/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class UriHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final String servletPath;
    private final String pathInfo;
    private final String uri;

    public UriHttpServletRequestWrapper(HttpServletRequest request, String servletPath, String pathInfo) {
        super(request);
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        StringBuffer buffer = new StringBuffer();
        if (request.getContextPath() != null) {
            buffer.append(request.getContextPath());
        }
        if (buffer.length() == 1 && buffer.charAt(0) == '/') {
            buffer.deleteCharAt(0);
        }
        if (servletPath != null) {
            buffer.append(servletPath);
        }
        if (pathInfo != null) {
            buffer.append(pathInfo);
        }
        if (buffer.charAt(0) != '/') {
            buffer.insert(0, '/');
        }
        this.uri = buffer.toString();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public StringBuffer getRequestURL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getProtocol());
        buffer.append("://");
        buffer.append(this.getServerName());
        boolean appendPort = true;
        if (this.getScheme().equals("http") && this.getServerPort() == 80) {
            appendPort = false;
        }
        if (this.getScheme().equals("https") && this.getServerPort() == 443) {
            appendPort = false;
        }
        if (appendPort) {
            buffer.append(':');
            buffer.append(this.getServerPort());
        }
        buffer.append(this.uri);
        return buffer;
    }

    public String getServletPath() {
        return this.servletPath;
    }
}

