/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.background;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.background.BackgroundSession;
import org.apache.cocoon.environment.impl.AbstractRequest;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.SystemUtils;

public class BackgroundRequest
extends AbstractRequest {
    private static final EmptyEnumeration SHARED_EMPTY_ENUMERATION = new EmptyEnumeration();
    private Environment env;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private Map globalAttributes;
    private Map attributes;
    private Map parameters;
    private Map headers;
    private String characterEncoding;

    public BackgroundRequest(Environment env, String contextPath, String servletPath, String pathInfo) {
        this(env, contextPath, servletPath, pathInfo, null, null, null);
    }

    public BackgroundRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes) {
        this(env, contextPath, servletPath, pathInfo, attributes, null, null);
    }

    public BackgroundRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters) {
        this(env, contextPath, servletPath, pathInfo, attributes, parameters, null);
    }

    public BackgroundRequest(Environment env, String contextPath, String servletPath, String pathInfo, Map attributes, Map parameters, Map headers) {
        this.env = env;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.globalAttributes = attributes == null ? new HashMap() : attributes;
        this.attributes = new HashMap();
        this.parameters = parameters;
        this.headers = headers;
    }

    public Object get(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        Vector<String> vect = new Vector<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            vect.add(values[i]);
        }
        return vect;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestURI() {
        StringBuffer buffer = new StringBuffer();
        if (this.servletPath != null) {
            buffer.append(this.servletPath);
        }
        if (this.contextPath != null) {
            buffer.append(this.contextPath);
        }
        if (this.pathInfo != null) {
            buffer.append(this.pathInfo);
        }
        return buffer.toString();
    }

    public String getSitemapURI() {
        return this.env.getURI();
    }

    public String getSitemapURIPrefix() {
        return this.env.getURIPrefix();
    }

    public String getSitemapPath() {
        return this.env.getURIPrefix();
    }

    public String getQueryString() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.globalAttributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return IteratorUtils.asEnumeration(this.globalAttributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.globalAttributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.globalAttributes.remove(name);
    }

    public Object getLocalAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getLocalAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributes.keySet().iterator());
    }

    public void setLocalAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeLocalAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object value = this.parameters.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        String[] values = (String[])value;
        if (values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration getParameterNames() {
        return this.parameters != null ? IteratorUtils.asEnumeration(this.parameters.keySet().iterator()) : null;
    }

    public String[] getParameterValues(String name) {
        Object value = this.parameters.get(name);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return (String[])value;
    }

    public String getHeader(String name) {
        return this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
    }

    public int getIntHeader(String name) {
        String header = this.headers != null ? (String)this.headers.get(name.toLowerCase()) : null;
        return header != null ? Integer.parseInt(header) : -1;
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public Enumeration getHeaders(String name) {
        return SHARED_EMPTY_ENUMERATION;
    }

    public Enumeration getHeaderNames() {
        if (this.headers != null) {
            return IteratorUtils.asEnumeration(this.headers.keySet().iterator());
        }
        return SHARED_EMPTY_ENUMERATION;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public String getProtocol() {
        return "cli";
    }

    public String getScheme() {
        return "cli";
    }

    public String getServerName() {
        return Constants.COMPLETE_NAME;
    }

    public int getServerPort() {
        return -1;
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getMethod() {
        return "get";
    }

    public String getRemoteUser() {
        return SystemUtils.USER_NAME;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return null;
    }

    public Map getCookieMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    public Cookie[] getCocoonCookies() {
        return null;
    }

    public Map getCocoonCookieMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return BackgroundSession.getSession(create);
    }

    public Session getCocoonSession(boolean create) {
        return (Session)this.getSession(create);
    }

    public Session getCocoonSession() {
        return (Session)this.getSession();
    }

    public String getRequestedSessionId() {
        return BackgroundSession.getSession(false) != null ? BackgroundSession.getSession(false).getId() : null;
    }

    public boolean isRequestedSessionIdValid() {
        return BackgroundSession.getSession(false) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        throw new NotImplementedException(((Object)((Object)this)).getClass().getName() + ".getLocales() method not yet implemented!");
    }

    public String getAuthType() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public ServletInputStream getInputStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object searchAttribute(String name) {
        Object result = this.getLocalAttribute(name);
        if (result == null) {
            result = this.getAttribute(name);
        }
        return result;
    }

    private static final class EmptyEnumeration
    implements Enumeration {
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

