/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import org.apache.cocoon.components.source.impl.CachedSourceResponse;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.cocoon.components.source.impl.CachingSourceValidityStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;

public class ExpiresCachingSourceValidityStrategy
implements CachingSourceValidityStrategy {
    private Log logger = LogFactory.getLog(this.getClass());

    public SourceValidity[] getCacheValidities(CachingSource cachingSource, Source source) {
        return new SourceValidity[]{new ExpiresValidity(cachingSource.getExpiration()), source.getValidity()};
    }

    public boolean checkValidity(CachedSourceResponse response, Source source, long expires) {
        SourceValidity[] validities = response.getValidityObjects();
        boolean valid = true;
        ExpiresValidity expiresValidity = (ExpiresValidity)validities[0];
        SourceValidity sourceValidity = validities[1];
        if (expiresValidity.isValid() != 1) {
            int validity;
            int n = validity = sourceValidity != null ? sourceValidity.isValid() : -1;
            if (validity == -1 || validity == 0 && sourceValidity.isValid(source.getValidity()) != 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Response expired, invalid for " + this.logger));
                }
                valid = false;
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Response expired, still valid for " + this.logger));
                }
                validities[0] = new ExpiresValidity(expires);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Response not expired for " + this.logger));
        }
        return valid;
    }
}

