/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.helpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.helpers.SourceRefresher;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.background.BackgroundEnvironment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.thread.RunnableManager;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.NetUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class DelaySourceRefresher
extends AbstractLogEnabled
implements SourceRefresher {
    private static final long DEFAULT_INTERVAL = 0L;
    private static final String DEFAULT_WRITE_FILE = "refresher-targets.xml";
    private static final String TAGNAME_TARGET = "target";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_INTERVAL = "interval";
    protected org.apache.avalon.framework.context.Context context;
    protected SourceResolver resolver;
    protected RunnableManager runnable;
    protected ServiceManager manager;
    protected Settings settings;
    protected long writeInterval = 0L;
    protected String fileName = "refresher-targets.xml";
    protected Map entries = Collections.synchronizedMap(new HashMap());
    protected File configFile;
    protected volatile boolean changed;
    protected ConfigurationTask configurationTask;

    public void init() throws ConfigurationException {
        if (this.writeInterval > 0L) {
            File workDir = new File(this.settings.getWorkDirectory());
            this.configFile = new File(workDir, this.fileName);
            if (this.configFile.exists() && !this.configFile.canWrite()) {
                throw new ConfigurationException("Parameter 'write-source' resolves to not modifiable file: " + this.configFile);
            }
            if (!this.configFile.getParentFile().exists() && !this.configFile.getParentFile().mkdirs()) {
                throw new ConfigurationException("Can not create parent directory for: " + this.configFile);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Write source location: " + this.configFile));
            }
            this.setupRefreshJobs(this.readRefreshJobConfiguration());
            this.startConfigurationTask(this.writeInterval);
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((Object)"Not writing update targets to file.");
        }
    }

    public void destroy() {
        this.stopConfigurationTask();
    }

    public void refresh(String name, String uri, Parameters parameters) throws SourceException {
        long interval = parameters.getParameterAsLong(ATTR_INTERVAL, -1L);
        if (uri != null && interval > 0L) {
            this.addRefreshSource(name, uri, interval, interval);
        } else {
            this.removeRefreshSource(name);
        }
    }

    protected void addRefreshSource(String key, String uri, long delay, long interval) {
        RefresherTask task = (RefresherTask)this.entries.get(key);
        if (task == null) {
            task = new RefresherTask(key, uri, interval);
            this.entries.put(key, task);
            this.runnable.execute((Runnable)task, interval, interval);
            this.changed = true;
        } else if (task.interval != interval) {
            task.update(uri, interval);
            this.runnable.remove((Runnable)task);
            this.runnable.execute((Runnable)task, interval, interval);
            this.changed = true;
        }
    }

    protected void removeRefreshSource(String key) {
        RefresherTask task = (RefresherTask)this.entries.get(key);
        if (task != null) {
            this.entries.remove(key);
            this.runnable.remove((Runnable)task);
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configuration readRefreshJobConfiguration() {
        Source source = null;
        SAXConfigurationHandler b = new SAXConfigurationHandler();
        try {
            block4: {
                try {
                    if (!this.configFile.exists()) break block4;
                    source = this.resolver.resolveURI(this.configFile.toURL().toString());
                    SourceUtil.toSAX((ServiceManager)this.manager, (Source)source, (String)source.getMimeType(), (ContentHandler)b);
                }
                catch (Exception ignore) {
                    this.getLogger().warn((Object)("Unable to read configuration from " + this.configFile));
                    Object var5_4 = null;
                    if (source == null) return b.getConfiguration();
                    this.resolver.release(source);
                    return b.getConfiguration();
                }
            }
            Object var5_3 = null;
            if (source == null) return b.getConfiguration();
            this.resolver.release(source);
            return b.getConfiguration();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (source == null) throw throwable;
            this.resolver.release(source);
            throw throwable;
        }
    }

    private void setupRefreshJobs(Configuration conf) {
        Configuration[] children;
        if (conf != null && (children = conf.getChildren(TAGNAME_TARGET)) != null) {
            for (int i = 0; i < children.length; ++i) {
                try {
                    this.setupSingleRefreshJob(children[i]);
                    continue;
                }
                catch (CascadingException ignore) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug((Object)"Setting up refresh job, ignoring exception:", (Throwable)ignore);
                }
            }
        }
    }

    private void setupSingleRefreshJob(Configuration conf) throws ConfigurationException {
        try {
            String key = NetUtils.decode((String)conf.getAttribute(ATTR_KEY), (String)"utf-8");
            String uri = NetUtils.decode((String)conf.getAttribute(ATTR_URI), (String)"utf-8");
            long interval = conf.getAttributeAsLong(ATTR_INTERVAL);
            this.addRefreshSource(key, uri, 10L, interval);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void startConfigurationTask(long interval) {
        this.configurationTask = new ConfigurationTask();
        this.runnable.execute((Runnable)this.configurationTask, interval, interval);
    }

    protected void stopConfigurationTask() {
        if (this.configurationTask != null) {
            this.runnable.remove((Runnable)this.configurationTask);
            this.configurationTask.run();
            this.configurationTask = null;
        }
    }

    public void setServiceManager(ServiceManager manager) {
        this.manager = manager;
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.resolver = resolver;
    }

    public void setRunnableManager(RunnableManager runnable) {
        this.runnable = runnable;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setWriteFile(String fileName) {
        this.fileName = fileName;
    }

    public void setWriteInterval(long interval) {
        this.writeInterval = interval;
    }

    public void setAvalonContext(org.apache.avalon.framework.context.Context context) {
        this.context = context;
    }

    protected class RefresherTask
    extends AbstractLogEnabled
    implements Runnable {
        private final String key;
        private String uri;
        private long interval;

        public RefresherTask(String key, String uri, long interval) {
            this.key = key;
            this.uri = uri;
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Processor processor;
            BackgroundEnvironment env;
            if (this.uri == null) return;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Refreshing " + this.uri));
            }
            try {
                Context ctx = (Context)DelaySourceRefresher.this.context.get((Object)"environment-context");
                env = new BackgroundEnvironment(ctx);
            }
            catch (ContextException e) {
                throw new CascadingRuntimeException("No context found", (Throwable)e);
            }
            try {
                processor = (Processor)DelaySourceRefresher.this.manager.lookup(Processor.ROLE);
            }
            catch (ServiceException e) {
                throw new CascadingRuntimeException("No processor found", (Throwable)e);
            }
            env.startingProcessing();
            try {
                EnvironmentHelper.enterProcessor((Processor)processor, (Environment)env);
            }
            catch (ProcessingException e) {
                throw new CascadingRuntimeException("Can not enter processor", (Throwable)e);
            }
            try {
                block14: {
                    Source source = null;
                    try {
                        try {
                            source = DelaySourceRefresher.this.resolver.resolveURI(this.uri);
                            source.refresh();
                        }
                        catch (IOException e) {
                            this.getLogger().error((Object)"Error refreshing source", (Throwable)e);
                            Object var6_8 = null;
                            if (source != null) {
                                DelaySourceRefresher.this.resolver.release(source);
                            }
                            break block14;
                        }
                        Object var6_7 = null;
                        if (source == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (source == null) throw throwable;
                        DelaySourceRefresher.this.resolver.release(source);
                        throw throwable;
                    }
                    DelaySourceRefresher.this.resolver.release(source);
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                EnvironmentHelper.leaveProcessor();
                env.finishingProcessing();
                if (DelaySourceRefresher.this.manager == null) throw throwable;
                DelaySourceRefresher.this.manager.release((Object)processor);
                throw throwable;
            }
            EnvironmentHelper.leaveProcessor();
            env.finishingProcessing();
            if (DelaySourceRefresher.this.manager == null) return;
            DelaySourceRefresher.this.manager.release((Object)processor);
        }

        public void update(String uri, long interval) {
            this.uri = uri;
            this.interval = interval;
        }

        public String toXML() {
            String key = null;
            String uri = null;
            try {
                key = NetUtils.encode((String)this.key, (String)"utf-8");
                uri = NetUtils.encode((String)this.uri, (String)"utf-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            StringBuffer s = new StringBuffer();
            s.append('<').append(DelaySourceRefresher.TAGNAME_TARGET).append(' ');
            s.append(DelaySourceRefresher.ATTR_KEY).append("=\"").append(key).append("\" ");
            s.append(DelaySourceRefresher.ATTR_URI).append("=\"").append(uri).append("\" ");
            s.append(DelaySourceRefresher.ATTR_INTERVAL).append("=\"").append(this.interval).append("\" />\n");
            return s.toString();
        }
    }

    protected class ConfigurationTask
    extends AbstractLogEnabled
    implements Runnable {
        protected ConfigurationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            if (DelaySourceRefresher.this.changed) {
                block17: {
                    DelaySourceRefresher.this.changed = false;
                    success = true;
                    writer = null;
                    try {
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(DelaySourceRefresher.this.configFile), "utf-8");
                        writer.write("<targets>\n");
                        try {
                            i = DelaySourceRefresher.this.entries.values().iterator();
                            while (i.hasNext()) {
                                task = (RefresherTask)i.next();
                                writer.write(task.toXML());
                            }
                        }
                        catch (ConcurrentModificationException e) {
                            success = false;
                        }
                        writer.write("</targets>\n");
                        var6_7 = null;
                        ** if (writer == null) goto lbl-1000
                    }
                    catch (Throwable var5_13) {
                        var6_9 = null;
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var5_13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                        catch (IOException e) {
                            success = false;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)"Error writing targets to file.", (Throwable)e);
                            }
                            var6_8 = null;
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                if (!success) {
                    DelaySourceRefresher.this.changed = true;
                }
            }
        }
    }
}

