/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.IOException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.URLRewriter;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.Source;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class SourceUtil
extends org.apache.cocoon.components.source.util.SourceUtil {
    private static ServiceManager getSitemapServiceManager() {
        return EnvironmentHelper.getSitemapServiceManager();
    }

    public static void toSAX(Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        SourceUtil.toSAX((ServiceManager)SourceUtil.getSitemapServiceManager(), (Source)source, null, (ContentHandler)handler);
    }

    public static void toSAX(Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        SourceUtil.toSAX((ServiceManager)SourceUtil.getSitemapServiceManager(), (Source)source, (String)mimeTypeHint, (ContentHandler)handler);
    }

    public static void toSAX(Source source, ContentHandler handler, Parameters typeParameters, boolean filterDocumentEvent) throws SAXException, IOException, ProcessingException {
        if (typeParameters != null && typeParameters.getParameter("rewriteURLMode", null) != null) {
            handler = new URLRewriter(typeParameters, handler);
        }
        String mimeTypeHint = null;
        if (typeParameters != null) {
            mimeTypeHint = typeParameters.getParameter("mime-type", mimeTypeHint);
        }
        if (filterDocumentEvent) {
            IncludeXMLConsumer filter = new IncludeXMLConsumer(handler);
            SourceUtil.toSAX(source, mimeTypeHint, (ContentHandler)filter);
        } else {
            SourceUtil.toSAX(source, mimeTypeHint, handler);
        }
    }

    public static Document toDOM(Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(source, (ContentHandler)builder);
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }
}

