/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.I18nUtils;

public class LocaleAction
extends ServiceableAction
implements ThreadSafe,
Configurable {
    private static final String DEFAULT_DEFAULT_LANG = "en";
    private static final String DEFAULT_DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_DEFAULT_VARIANT = "";
    public static final String LOCALE = "locale";
    public static final String LOCALE_ATTR = "locale-attribute";
    public static final String STORE_REQUEST = "store-in-request";
    public static final String CREATE_SESSION = "create-session";
    public static final String STORE_SESSION = "store-in-session";
    public static final String STORE_COOKIE = "store-in-cookie";
    private String localeAttribute;
    private boolean useLocale;
    private Locale defaultLocale;
    private boolean storeInRequest;
    private boolean storeInSession;
    private boolean createSession;
    private boolean storeInCookie;

    public void configure(Configuration config) throws ConfigurationException {
        this.storeInRequest = config.getChild(STORE_REQUEST).getValueAsBoolean(false);
        this.createSession = config.getChild(CREATE_SESSION).getValueAsBoolean(false);
        this.storeInSession = config.getChild(STORE_SESSION).getValueAsBoolean(false);
        this.storeInCookie = config.getChild(STORE_COOKIE).getValueAsBoolean(false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((this.storeInRequest ? "will" : "won't") + " set values in request"));
            this.getLogger().debug((Object)((this.createSession ? "will" : "won't") + " create session"));
            this.getLogger().debug((Object)((this.storeInSession ? "will" : "won't") + " set values in session"));
            this.getLogger().debug((Object)((this.storeInCookie ? "will" : "won't") + " set values in cookies"));
        }
        this.localeAttribute = config.getChild(LOCALE_ATTR).getValue(LOCALE);
        this.useLocale = config.getChild("use-locale").getValueAsBoolean(true);
        Configuration child = config.getChild("default-locale", false);
        if (child != null) {
            this.defaultLocale = new Locale(child.getAttribute("language", DEFAULT_DEFAULT_LANG), child.getAttribute("country", DEFAULT_DEFAULT_COUNTRY), child.getAttribute("variant", DEFAULT_DEFAULT_VARIANT));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Locale attribute name is " + this.localeAttribute));
            this.getLogger().debug((Object)((this.useLocale ? "will" : "won't") + " use request locale"));
            this.getLogger().debug((Object)("default locale " + this.defaultLocale));
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters params) throws Exception {
        Locale locale = I18nUtils.findLocale(objectModel, this.localeAttribute, params, this.defaultLocale, this.useLocale);
        if (locale == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"No locale found.");
            }
            return null;
        }
        String localeStr = locale.toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Found locale: " + localeStr));
        }
        I18nUtils.storeLocale(objectModel, this.localeAttribute, localeStr, this.storeInRequest, this.storeInSession, this.storeInCookie, this.createSession);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("language", locale.getLanguage());
        map.put("country", locale.getCountry());
        map.put("variant", locale.getVariant());
        map.put(LOCALE, localeStr);
        return map;
    }

    public static String getLocaleAttribute(Map objectModel, String localeAttrName) {
        Locale locale = I18nUtils.findLocale(objectModel, localeAttrName, null, null, true);
        return locale.toString();
    }
}

