/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.util.Enumeration;
import java.util.HashSet;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.wrapper.AbstractRequestWrapper;
import org.apache.cocoon.environment.wrapper.RequestParameters;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public final class RequestWrapper
extends AbstractRequestWrapper {
    private String queryString;
    private final RequestParameters parameters;
    private final Environment environment;
    private final boolean rawMode;
    private String requestURI;

    public RequestWrapper(Request request, String requestURI, String queryString, Environment env) {
        this(request, requestURI, queryString, env, false);
    }

    public RequestWrapper(Request request, String requestURI, String queryString, Environment env, boolean rawMode) {
        super(request);
        this.environment = env;
        this.queryString = queryString;
        this.parameters = new RequestParameters(queryString);
        this.rawMode = rawMode;
        if (this.req.getQueryString() != null && !this.rawMode) {
            this.queryString = this.queryString == null ? this.req.getQueryString() : this.queryString + '&' + this.req.getQueryString();
        }
        this.requestURI = this.req.getRequestURI();
    }

    public String getParameter(String name) {
        String value = this.parameters.getParameter(name);
        if (value == null && !this.rawMode) {
            return this.req.getParameter(name);
        }
        return value;
    }

    public Enumeration getParameterNames() {
        if (!this.rawMode) {
            HashSet parameterNames = new HashSet();
            Enumeration names = this.parameters.getParameterNames();
            while (names.hasMoreElements()) {
                parameterNames.add(names.nextElement());
            }
            names = this.req.getParameterNames();
            while (names.hasMoreElements()) {
                parameterNames.add(names.nextElement());
            }
            return new IteratorEnumeration(parameterNames.iterator());
        }
        return this.parameters.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.rawMode) {
            String[] values = this.parameters.getParameterValues(name);
            String[] inherited = this.req.getParameterValues(name);
            if (inherited == null) {
                return values;
            }
            if (values == null) {
                return inherited;
            }
            String[] allValues = new String[values.length + inherited.length];
            System.arraycopy(values, 0, allValues, 0, values.length);
            System.arraycopy(inherited, 0, allValues, values.length, inherited.length);
            return allValues;
        }
        return this.parameters.getParameterValues(name);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getSitemapURI() {
        return this.environment.getURI();
    }

    public String getSitemapURIPrefix() {
        return this.environment.getURIPrefix();
    }

    public String getSitemapPath() {
        return this.environment.getURIPrefix();
    }

    public void setRequestURI(String prefix, String uri) {
        StringBuffer buffer = new StringBuffer(this.getContextPath());
        buffer.append('/');
        buffer.append(prefix);
        buffer.append(uri);
        this.requestURI = buffer.toString();
    }
}

