/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.internal;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.environment.internal.UnableToPopEnvironmentException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class PopEnvironmentChanger
implements XMLConsumer {
    final XMLConsumer consumer;

    PopEnvironmentChanger(XMLConsumer consumer) {
        this.consumer = consumer;
    }

    private Environment leaveEnvironment() {
        return EnvironmentHelper.leaveEnvironment();
    }

    private void enterEnvironment(Environment environment) throws SAXException {
        try {
            EnvironmentHelper.enterEnvironment(environment);
        }
        catch (ProcessingException e) {
            throw new SAXException("Unable to enter the environment: " + environment, (Exception)((Object)e));
        }
    }

    public void setDocumentLocator(Locator locator) {
        Environment environment = this.leaveEnvironment();
        this.consumer.setDocumentLocator(locator);
        try {
            this.enterEnvironment(environment);
        }
        catch (SAXException e) {
            throw new UnableToPopEnvironmentException("Unable to re-enter the environment: " + environment, e);
        }
    }

    public void startDocument() throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startDocument();
        this.enterEnvironment(environment);
    }

    public void endDocument() throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endDocument();
        this.enterEnvironment(environment);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startPrefixMapping(prefix, uri);
        this.enterEnvironment(environment);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endPrefixMapping(prefix);
        this.enterEnvironment(environment);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startElement(uri, loc, raw, a);
        this.enterEnvironment(environment);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endElement(uri, loc, raw);
        this.enterEnvironment(environment);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.characters(c, start, len);
        this.enterEnvironment(environment);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.ignorableWhitespace(c, start, len);
        this.enterEnvironment(environment);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.processingInstruction(target, data);
        this.enterEnvironment(environment);
    }

    public void skippedEntity(String name) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.skippedEntity(name);
        this.enterEnvironment(environment);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startDTD(name, publicId, systemId);
        this.enterEnvironment(environment);
    }

    public void endDTD() throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endDTD();
        this.enterEnvironment(environment);
    }

    public void startEntity(String name) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startEntity(name);
        this.enterEnvironment(environment);
    }

    public void endEntity(String name) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endEntity(name);
        this.enterEnvironment(environment);
    }

    public void startCDATA() throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.startCDATA();
        this.enterEnvironment(environment);
    }

    public void endCDATA() throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.endCDATA();
        this.enterEnvironment(environment);
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        Environment environment = this.leaveEnvironment();
        this.consumer.comment(ch, start, len);
        this.enterEnvironment(environment);
    }
}

