/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.logger;

import org.apache.cocoon.core.container.spring.logger.LoggerFactoryBean;
import org.apache.cocoon.core.container.spring.logger.LoggerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.HierarchicalBeanFactory;

public class ChildLoggerFactoryBean
extends LoggerFactoryBean
implements FactoryBean,
BeanFactoryAware {
    private BeanFactory factory;

    public ChildLoggerFactoryBean() {
        this.setCategory(null);
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void init() {
        BeanFactory parent = ((HierarchicalBeanFactory)this.factory).getParentBeanFactory();
        LoggerFactoryBean bean = (LoggerFactoryBean)parent.getBean("&org.apache.cocoon.core.container.spring.logger.Log");
        this.setCategory(LoggerUtils.getChildCategory(bean, this.getCategory()));
        this.setLogger(LogFactory.getLog((String)this.getCategory()));
    }

    public Object getObject() throws Exception {
        BeanFactory parent = ((HierarchicalBeanFactory)this.factory).getParentBeanFactory();
        return LoggerUtils.getChildLogger(parent, this.getCategory());
    }

    public Class getObjectType() {
        return Log.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

