/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.cocoon.core.container.spring.avalon.SourceIOInputStream;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.springframework.core.io.Resource;

public class SourceResource
implements Resource {
    protected Source source;
    protected SourceResolver resolver;
    protected boolean open;

    public SourceResource(Source s, SourceResolver r) {
        this.source = s;
        this.resolver = r;
    }

    public InputStream getInputStream() throws IOException {
        this.open = true;
        return new SourceIOInputStream(this.resolver, this.source);
    }

    public Resource createRelative(String uri) throws IOException {
        int pos = this.source.getURI().lastIndexOf(47);
        return new SourceResource(this.resolver.resolveURI(uri, this.source.getURI().substring(0, pos), null), this.resolver);
    }

    public boolean exists() {
        return this.source.exists();
    }

    public String getDescription() {
        return "Source: " + this.source;
    }

    public File getFile() throws IOException {
        return SourceUtil.getFile((Source)this.source);
    }

    public String getFilename() {
        int pos = this.source.getURI().lastIndexOf(47);
        return this.source.getURI().substring(pos + 1);
    }

    public URL getURL() throws IOException {
        return new URL(this.source.getURI());
    }

    public String getUrlString() {
        return this.source.getURI();
    }

    public boolean isOpen() {
        return this.open;
    }

    public URI getURI() throws IOException {
        try {
            return new URI(this.source.getURI());
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException("Exception because of the URI syntax.");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

