/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.classloader.reloading.Monitor;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.apache.cocoon.spring.configurator.impl.ChildXmlWebApplicationContext;
import org.apache.cocoon.util.Deprecation;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;

public class SitemapHelper {
    private static final String CLASSLOADER_CONFIG_NAME = "classloader";
    private static final String DEFAULT_CONFIG_XCONF = "config/avalon";
    public static final String DEFAULT_CHILD_SPRING_CONFIGURATION_LOCATION = "config/spring";
    public static final String DEFAULT_CHILD_PROPERTIES_LOCATION = "config/properties";

    protected static String createDefinition(String uriPrefix, String sitemapLocation, List beanIncludes, List propertyIncludes, Properties props) {
        String dir;
        Iterator i;
        StringBuffer buffer = new StringBuffer();
        SitemapHelper.addHeader(buffer);
        buffer.append("  <configurator:child-settings");
        SitemapHelper.addAttribute(buffer, "name", sitemapLocation);
        buffer.append(">\n");
        if (beanIncludes != null) {
            i = beanIncludes.iterator();
            while (i.hasNext()) {
                dir = (String)i.next();
                buffer.append("    <configurator:include-beans");
                SitemapHelper.addAttribute(buffer, "dir", dir);
                buffer.append("/>\n");
            }
        }
        if (propertyIncludes != null) {
            i = propertyIncludes.iterator();
            while (i.hasNext()) {
                dir = (String)i.next();
                buffer.append("    <configurator:include-properties");
                SitemapHelper.addAttribute(buffer, "dir", dir);
                buffer.append("/>\n");
            }
        }
        if (props != null) {
            Iterator<Object> kI = props.keySet().iterator();
            while (kI.hasNext()) {
                String key = (String)kI.next();
                buffer.append("    <configurator:property");
                SitemapHelper.addAttribute(buffer, "name", key);
                SitemapHelper.addAttribute(buffer, "value", props.getProperty(key));
                buffer.append("/>\n");
            }
        }
        buffer.append("  </configurator:child-settings>\n");
        buffer.append("  <avalon:sitemap");
        SitemapHelper.addAttribute(buffer, "location", sitemapLocation);
        SitemapHelper.addAttribute(buffer, "uriPrefix", uriPrefix);
        buffer.append("/>\n");
        SitemapHelper.addFooter(buffer);
        return buffer.toString();
    }

    protected static void addHeader(StringBuffer buffer) {
        buffer.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        buffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        buffer.append(" xmlns:util=\"http://www.springframework.org/schema/util\"");
        buffer.append(" xmlns:configurator=\"http://cocoon.apache.org/schema/configurator\"");
        buffer.append(" xmlns:avalon=\"http://cocoon.apache.org/schema/avalon\"");
        buffer.append(" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd");
        buffer.append(" http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util-2.0.xsd");
        buffer.append(" http://cocoon.apache.org/schema/configurator http://cocoon.apache.org/schema/configurator/cocoon-configurator-1.0.xsd");
        buffer.append(" http://cocoon.apache.org/schema/avalon http://cocoon.apache.org/schema/avalon/cocoon-avalon-1.0.xsd\">\n");
    }

    protected static void addFooter(StringBuffer buffer) {
        buffer.append("</beans>\n");
    }

    protected static void addAttribute(StringBuffer buffer, String name, String value) {
        if (value != null) {
            buffer.append(' ');
            buffer.append(name);
            buffer.append("=\"");
            buffer.append(value);
            buffer.append("\"");
        }
    }

    protected static boolean isUsingDefaultIncludes(Configuration config) {
        return config.getChild("components").getAttributeAsBoolean("use-default-includes", true);
    }

    protected static List getBeanIncludes(WebApplicationContext webAppContext, String contextUrl, Configuration sitemap) throws ConfigurationException {
        Resource rsrc;
        ArrayList<String> includes = new ArrayList<String>();
        if (SitemapHelper.isUsingDefaultIncludes(sitemap) && (rsrc = webAppContext.getResource(contextUrl + DEFAULT_CHILD_SPRING_CONFIGURATION_LOCATION)).exists()) {
            includes.add(DEFAULT_CHILD_SPRING_CONFIGURATION_LOCATION);
        }
        Configuration[] includeConfigs = sitemap.getChild("components").getChildren("include-beans");
        for (int i = 0; i < includeConfigs.length; ++i) {
            String dir = includeConfigs[i].getAttribute("dir");
            includes.add(dir);
        }
        return includes;
    }

    protected static List getPropertiesIncludes(WebApplicationContext webAppContext, String contextUrl, Configuration sitemap) throws ConfigurationException {
        Resource rsrc;
        ArrayList<String> includes = new ArrayList<String>();
        if (SitemapHelper.isUsingDefaultIncludes(sitemap) && (rsrc = webAppContext.getResource(contextUrl + DEFAULT_CHILD_PROPERTIES_LOCATION)).exists()) {
            includes.add(DEFAULT_CHILD_PROPERTIES_LOCATION);
        }
        Configuration[] includeConfigs = sitemap.getChild("components").getChildren("include-properties");
        for (int i = 0; i < includeConfigs.length; ++i) {
            String dir = includeConfigs[i].getAttribute("dir");
            includes.add(dir);
        }
        return includes;
    }

    protected static Properties getGlobalSitemapVariables(Configuration sitemap) throws ConfigurationException {
        Properties variables = null;
        Configuration varConfig = sitemap.getChild("pipelines").getChild("component-configurations").getChild("global-variables", false);
        if (varConfig != null) {
            Deprecation.logger.warn((Object)"The 'component-configurations' section in the sitemap is deprecated. Please check for alternatives.");
            variables = new Properties();
            Configuration[] variableElements = varConfig.getChildren();
            for (int v = 0; v < variableElements.length; ++v) {
                variables.setProperty(variableElements[v].getName(), variableElements[v].getValue());
            }
        }
        return variables;
    }

    public static Configuration createSitemapConfiguration(Configuration config) throws ConfigurationException {
        Configuration componentConfig = config.getChild("components", false);
        boolean useDefaultIncludes = SitemapHelper.isUsingDefaultIncludes(config);
        if (componentConfig == null && useDefaultIncludes) {
            componentConfig = new DefaultConfiguration("components", config.getLocation(), config.getNamespace(), "");
        }
        if (componentConfig != null) {
            DefaultConfiguration c = new DefaultConfiguration(componentConfig.getName(), componentConfig.getLocation(), componentConfig.getNamespace(), "");
            c.addAll(componentConfig);
            Configuration classPathConfig = c.getChild(CLASSLOADER_CONFIG_NAME, false);
            if (classPathConfig != null) {
                c.removeChild(classPathConfig);
            }
            if (useDefaultIncludes) {
                DefaultConfiguration includeElement = new DefaultConfiguration("include", c.getLocation(), c.getNamespace(), "");
                includeElement.setAttribute("dir", DEFAULT_CONFIG_XCONF);
                includeElement.setAttribute("pattern", "*.xconf");
                includeElement.setAttribute("optional", "true");
                c.addChild((Configuration)includeElement);
            }
            componentConfig = c;
        }
        return componentConfig;
    }

    public static WebApplicationContext createContainer(Configuration config, String sitemapLocation, Monitor fam, ServletContext servletContext) throws Exception {
        WebApplicationContext parentContext = WebAppContextUtils.getCurrentWebApplicationContext();
        ProcessInfoProvider infoProvider = (ProcessInfoProvider)parentContext.getBean(ProcessInfoProvider.ROLE);
        Request request = ObjectModelHelper.getRequest((Map)infoProvider.getObjectModel());
        int pos = sitemapLocation.lastIndexOf(47);
        if (sitemapLocation.lastIndexOf(File.separatorChar) > pos) {
            pos = sitemapLocation.lastIndexOf(File.separatorChar);
        }
        String contextUrl = sitemapLocation.substring(0, pos + 1);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        String definition = SitemapHelper.createDefinition(request.getSitemapURIPrefix(), sitemapLocation.substring(pos + 1), SitemapHelper.getBeanIncludes(parentContext, contextUrl, config), SitemapHelper.getPropertiesIncludes(parentContext, contextUrl, config), SitemapHelper.getGlobalSitemapVariables(config));
        ChildXmlWebApplicationContext context = new ChildXmlWebApplicationContext(contextUrl, definition);
        context.setServletContext(servletContext);
        context.setParent((ApplicationContext)parentContext);
        if (classloader != null) {
            context.setClassLoader(classloader);
        }
        context.refresh();
        return context;
    }
}

