/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.configuration.PropertyHelper;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.avalon.AvalonPoolable;
import org.apache.cocoon.core.container.spring.avalon.PoolableProxyHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class PoolableFactoryBean
implements FactoryBean,
BeanFactoryAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_MAX_POOL_SIZE = "64";
    protected final Class[] interfaces;
    protected final String name;
    protected final Class beanClass;
    protected BeanFactory beanFactory;
    protected final Object semaphore = new Object();
    private final int max;
    private LinkedList ready;
    private int readySize;
    private int size;
    private int highWaterMark;
    protected String poolInMethodName;
    protected String poolOutMethodName;
    protected Method poolInMethod;
    protected Method poolOutMethod;

    public PoolableFactoryBean(String name, String className) throws Exception {
        this(name, className, DEFAULT_MAX_POOL_SIZE, null);
    }

    public PoolableFactoryBean(String name, String className, String poolMaxString, Settings settings) throws Exception {
        String value = poolMaxString;
        if (settings != null) {
            value = PropertyHelper.replace((String)poolMaxString, (Settings)settings);
        }
        int poolMax = Integer.valueOf(value);
        this.name = name;
        this.max = poolMax <= 0 ? Integer.MAX_VALUE : poolMax;
        this.beanClass = Class.forName(className);
        HashSet<Class> workInterfaces = new HashSet<Class>();
        this.guessWorkInterfaces(this.beanClass, workInterfaces);
        workInterfaces.add(AvalonPoolable.class);
        this.interfaces = workInterfaces.toArray(new Class[workInterfaces.size()]);
        this.ready = new LinkedList();
    }

    public void setPoolInMethodName(String poolInMethodName) {
        this.poolInMethodName = poolInMethodName;
    }

    public void setPoolOutMethodName(String poolOutMethodName) {
        this.poolOutMethodName = poolOutMethodName;
    }

    public void initialize() throws Exception {
        this.poolInMethod = this.poolInMethodName != null ? this.beanClass.getMethod(this.poolInMethodName, null) : null;
        this.poolOutMethod = this.poolOutMethodName != null ? this.beanClass.getMethod(this.poolOutMethodName, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.semaphore;
        synchronized (object) {
            Iterator iter = this.ready.iterator();
            while (iter.hasNext()) {
                Object poolable = iter.next();
                iter.remove();
                --this.readySize;
                this.permanentlyRemovePoolable(poolable);
            }
        }
    }

    protected void permanentlyRemovePoolable(Object poolable) {
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromPool() throws Exception {
        Object poolable;
        Object object = this.semaphore;
        synchronized (object) {
            if (this.readySize > 0) {
                poolable = this.ready.removeLast();
                --this.readySize;
            } else {
                poolable = this.beanFactory.getBean(this.name);
                ++this.size;
                this.highWaterMark = this.highWaterMark < this.size ? this.size : this.highWaterMark;
            }
        }
        this.exitingPool(poolable);
        return poolable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoPool(Object poolable) {
        this.enteringPool(poolable);
        Object object = this.semaphore;
        synchronized (object) {
            if (this.size <= this.max) {
                this.ready.addLast(poolable);
                ++this.readySize;
            } else {
                this.permanentlyRemovePoolable(poolable);
            }
        }
    }

    protected void exitingPool(Object component) throws Exception {
        if (this.poolOutMethod != null) {
            this.poolOutMethod.invoke(component, null);
        }
    }

    protected void enteringPool(Object component) {
        try {
            if (component instanceof Recyclable) {
                ((Recyclable)component).recycle();
            }
            if (this.poolInMethod != null) {
                this.poolInMethod.invoke(component, null);
            }
        }
        catch (Exception ignore) {
            this.log.error((Object)("Exception while putting component '" + component + "' back into the pool."), (Throwable)ignore);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object getObject() throws Exception {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), this.interfaces, (InvocationHandler)new PoolableProxyHandler(this));
    }

    public Class getObjectType() {
        return this.beanClass;
    }

    public boolean isSingleton() {
        return false;
    }

    private void guessWorkInterfaces(Class clazz, Set workInterfaces) {
        if (null != clazz) {
            this.addInterfaces(clazz.getInterfaces(), workInterfaces);
            this.guessWorkInterfaces(clazz.getSuperclass(), workInterfaces);
        }
    }

    private void addInterfaces(Class[] classInterfaces, Set workInterfaces) {
        for (int i = 0; i < classInterfaces.length; ++i) {
            workInterfaces.add(classInterfaces[i]);
            this.addInterfaces(classInterfaces[i].getInterfaces(), workInterfaces);
        }
    }
}

