/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.cocoon.core.container.spring.avalon.ComponentInfo;
import org.apache.cocoon.core.container.spring.avalon.ConfigurationInfo;
import org.apache.cocoon.core.container.spring.avalon.SitemapHelper;
import org.apache.cocoon.core.container.spring.avalon.SourceResource;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.xml.sax.InputSource;

public class ConfigurationReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ServletContextResourcePatternResolver resolver;
    protected final ConfigurationInfo configInfo;
    protected final List componentConfigs = new ArrayList();
    protected final boolean isRootContext;

    public static ConfigurationInfo readConfiguration(String source, ResourceLoader resourceLoader) throws Exception {
        ConfigurationReader converter = new ConfigurationReader(null, resourceLoader);
        converter.convert(source);
        return converter.configInfo;
    }

    public static ConfigurationInfo readSitemap(ConfigurationInfo parentInfo, String src, ResourceLoader resourceLoader) throws Exception {
        String source = src;
        if (source == null || source.trim().length() == 0) {
            source = "sitemap.xmap";
        }
        ConfigurationReader converter = new ConfigurationReader(parentInfo, resourceLoader);
        converter.convertSitemap(source);
        return converter.configInfo;
    }

    public static ConfigurationInfo readConfiguration(Configuration rolesConfig, Configuration componentConfig) throws Exception {
        ConfigurationReader converter = new ConfigurationReader(null, (ResourceLoader)new DefaultResourceLoader());
        converter.convert(rolesConfig, componentConfig, null);
        return converter.configInfo;
    }

    private ConfigurationReader(ConfigurationInfo parentInfo, ResourceLoader resourceLoader) throws Exception {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("ResourceLoader not set!");
        }
        this.isRootContext = parentInfo == null;
        this.resolver = new ServletContextResourcePatternResolver(resourceLoader);
        if (parentInfo != null) {
            this.configInfo = new ConfigurationInfo(parentInfo);
            Iterator i = parentInfo.getComponents().values().iterator();
            while (i.hasNext()) {
                ComponentInfo current = (ComponentInfo)i.next();
                if (!current.isSelector()) continue;
                this.configInfo.addRole(current.getRole(), current.copy());
            }
        } else {
            this.configInfo = new ConfigurationInfo();
        }
    }

    protected String convertUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("context:")) {
            return url.substring(10);
        }
        if (url.startsWith("resource:")) {
            return "classpath:" + url.substring(10);
        }
        return url;
    }

    protected String correctUrl(String url) {
        if (url.startsWith("file:")) {
            File f = new File(url.substring(5));
            return "file://" + f.getAbsolutePath();
        }
        return url;
    }

    protected String getUrl(Resource rsrc) throws IOException {
        if (rsrc instanceof SourceResource) {
            return ((SourceResource)rsrc).getUrlString();
        }
        return rsrc.getURL().toExternalForm();
    }

    protected String getUrl(String url, String base) {
        if (url == null || base == null) {
            return this.convertUrl(url);
        }
        if (url.indexOf(":/") < 2) {
            int posSeparator = base.lastIndexOf(47);
            int posFileSeparator = base.lastIndexOf(File.separatorChar);
            if (posFileSeparator > posSeparator) {
                posSeparator = posFileSeparator;
            }
            return this.convertUrl(base.substring(0, posSeparator + 1) + url);
        }
        return this.convertUrl(url);
    }

    protected InputSource getInputSource(Resource rsrc) throws IOException {
        InputSource is = new InputSource(rsrc.getInputStream());
        is.setSystemId(this.getUrl(rsrc));
        return is;
    }

    protected void convert(String relativePath) throws Exception {
        Resource root;
        DefaultConfigurationBuilder b;
        Configuration config;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Reading Avalon configuration from " + relativePath));
        }
        if (!"cocoon".equals((config = (b = new DefaultConfigurationBuilder(true)).build(this.getInputSource(root = this.resolver.getResource(this.getUrl(relativePath, null))))).getName())) {
            throw new ConfigurationException("Invalid configuration file\n" + config);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configuration version: " + config.getAttribute("version")));
        }
        if (!"2.2".equals(config.getAttribute("version"))) {
            throw new ConfigurationException("Invalid configuration schema version. Must be '2.2'.");
        }
        this.convert(config, null, this.getUrl(root));
    }

    protected void convertSitemap(String sitemapLocation) throws Exception {
        DefaultConfigurationBuilder b;
        Configuration config;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Reading sitemap from " + sitemapLocation));
        }
        Resource root = this.resolver.getResource(this.getUrl(sitemapLocation, null));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved sitemap: " + root.getURL()));
        }
        if (!"sitemap".equals((config = (b = new DefaultConfigurationBuilder(true)).build(this.getInputSource(root))).getName())) {
            throw new ConfigurationException("Invalid sitemap\n" + config);
        }
        Configuration completeConfig = SitemapHelper.createSitemapConfiguration(config);
        if (completeConfig != null) {
            this.convert(completeConfig, null, this.getUrl(root));
        }
    }

    protected void convert(Configuration config, Configuration additionalConfig, String rootUri) throws Exception {
        String userRoles;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Converting Avalon configuration from configuration object: " + config));
        }
        this.configInfo.setRootLogger(config.getAttribute("logger", null));
        HashSet loadedConfigs = new HashSet();
        if ("role-list".equals(config.getName()) || "roles".equals(config.getName())) {
            this.configureRoles(config);
        } else {
            this.parseConfiguration(config, null, loadedConfigs);
        }
        if (rootUri != null && (userRoles = config.getAttribute("user-roles", null)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading additional user roles: " + userRoles));
            }
            Resource userRolesSource = this.resolver.getResource(this.getUrl(userRoles, rootUri));
            DefaultConfigurationBuilder b = new DefaultConfigurationBuilder(true);
            Configuration userRolesConfig = b.build(this.getInputSource(userRolesSource));
            this.parseConfiguration(userRolesConfig, this.getUrl(userRolesSource), loadedConfigs);
        }
        if (additionalConfig != null) {
            if ("role-list".equals(additionalConfig.getName()) || "roles".equals(additionalConfig.getName())) {
                this.configureRoles(additionalConfig);
            } else {
                this.parseConfiguration(additionalConfig, null, loadedConfigs);
            }
        }
        this.processComponents();
        Iterator i = this.configInfo.getRoles().iterator();
        while (i.hasNext()) {
            ComponentInfo current = (ComponentInfo)i.next();
            if (!current.hasConfiguredLazyInit()) {
                current.setLazyInit(true);
            }
            this.configInfo.addComponent(current);
        }
        this.configInfo.clearRoles();
    }

    protected void parseConfiguration(Configuration configuration, String contextURI, Set loadedURIs) throws ConfigurationException {
        Configuration[] configurations = configuration.getChildren();
        for (int i = 0; i < configurations.length; ++i) {
            Configuration componentConfig = configurations[i];
            String componentName = componentConfig.getName();
            if ("include".equals(componentName)) {
                this.handleInclude(contextURI, loadedURIs, componentConfig);
                continue;
            }
            if ("include-beans".equals(componentName)) {
                if (!this.isRootContext) continue;
                this.handleBeanInclude(contextURI, componentConfig);
                continue;
            }
            if (!this.isRootContext && "include-properties".equals(componentName)) continue;
            this.componentConfigs.add(componentConfig);
        }
    }

    protected void processComponents() throws ConfigurationException {
        Iterator i = this.componentConfigs.iterator();
        while (i.hasNext()) {
            ComponentInfo info;
            Configuration componentConfig = (Configuration)i.next();
            String componentName = componentConfig.getName();
            String role = componentConfig.getAttribute("role", null);
            String alias = null;
            if (role == null) {
                role = (String)this.configInfo.getShorthands().get(componentName);
                alias = componentName;
                if (role == null) {
                    throw new ConfigurationException("Unknown component type '" + componentName + "' at " + componentConfig.getLocation());
                }
            }
            String className = componentConfig.getAttribute("class", null);
            String name = componentConfig.getAttribute("name", null);
            if (className == null) {
                info = this.configInfo.getRole(role);
                if (info == null) {
                    if (this.configInfo.getComponents().get(role) != null) {
                        throw new ConfigurationException("Duplicate component definition for role " + role + " at " + componentConfig.getLocation());
                    }
                    throw new ConfigurationException("Cannot find a class for role " + role + " at " + componentConfig.getLocation());
                }
                className = info.getComponentClassName();
                if (name != null) {
                    info = info.copy();
                } else if (!className.endsWith("Selector")) {
                    this.configInfo.removeRole(role);
                }
            } else {
                info = new ComponentInfo();
                if (!className.endsWith("Selector")) {
                    this.configInfo.removeRole(role);
                }
            }
            if (name != null) {
                role = role + "/" + name;
                if (alias != null) {
                    alias = alias + '-' + name;
                }
            }
            info.fill(componentConfig);
            info.setComponentClassName(className);
            info.setRole(role);
            if (alias != null) {
                info.setAlias(alias);
            }
            info.setConfiguration(componentConfig);
            boolean isSelector = className.endsWith("Selector");
            if (!isSelector && this.configInfo.getComponents().get(role) != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Duplicate component definition for role " + role + " at " + componentConfig.getLocation() + ". Component " + "has already been defined at " + ((ComponentInfo)this.configInfo.getComponents().get(role)).getConfiguration().getLocation()));
            }
            this.configInfo.addComponent(info);
            if (info.getConfiguration() == null || !className.endsWith("Selector")) continue;
            String classAttribute = null;
            if (className.equals("org.apache.cocoon.core.container.DefaultServiceSelector")) {
                classAttribute = "class";
            } else if (className.equals("org.apache.cocoon.components.treeprocessor.sitemap.ComponentsSelector")) {
                classAttribute = "src";
            }
            if (classAttribute == null) {
                this.logger.warn((Object)("Found unknown selector type (continuing anyway: " + className));
                continue;
            }
            String componentRole = role;
            if (componentRole.endsWith("Selector")) {
                componentRole = componentRole.substring(0, componentRole.length() - 8);
            }
            componentRole = componentRole + '/';
            Configuration[] children = info.getConfiguration().getChildren();
            Map hintConfigs = (Map)this.configInfo.getKeyClassNames().get(role);
            for (int j = 0; j < children.length; ++j) {
                ComponentInfo hintInfo;
                Configuration current = children[j];
                ComponentInfo childInfo = new ComponentInfo();
                childInfo.fill(current);
                childInfo.setConfiguration(current);
                ComponentInfo componentInfo = hintInfo = hintConfigs == null ? null : (ComponentInfo)hintConfigs.get(current.getName());
                if (current.getAttribute(classAttribute, null) != null || hintInfo == null) {
                    childInfo.setComponentClassName(current.getAttribute(classAttribute));
                } else {
                    childInfo.setComponentClassName(hintInfo.getComponentClassName());
                }
                childInfo.setRole(componentRole + current.getAttribute("name"));
                this.configInfo.addComponent(childInfo);
            }
        }
    }

    protected void handleInclude(String contextURI, Set loadedURIs, Configuration includeStatement) throws ConfigurationException {
        Resource dirResource;
        String includeURI = includeStatement.getAttribute("src", null);
        String directoryURI = null;
        if (includeURI == null) {
            directoryURI = includeStatement.getAttribute("dir", null);
        }
        if (includeURI == null && directoryURI == null) {
            throw new ConfigurationException("Include statement must either have a 'src' or 'dir' attribute, at " + includeStatement.getLocation());
        }
        if (includeURI != null) {
            try {
                Resource src = this.resolver.getResource(this.getUrl(includeURI, contextURI));
                this.loadURI(src, loadedURIs, includeStatement);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load '" + includeURI + "' at " + includeStatement.getLocation(), (Throwable)e);
            }
        }
        boolean load = true;
        if (!ResourceUtils.isClasspathUri((String)directoryURI) && !(dirResource = this.resolver.getResource(this.getUrl(directoryURI, contextURI))).exists()) {
            if (!includeStatement.getAttributeAsBoolean("optional", false)) {
                throw new ConfigurationException("Directory '" + directoryURI + "' does not exist (" + includeStatement.getLocation() + ").");
            }
            load = false;
        }
        if (load) {
            String pattern = includeStatement.getAttribute("pattern", null);
            try {
                Resource[] resources = this.resolver.getResources(this.getUrl(directoryURI + '/' + pattern, contextURI));
                if (resources != null) {
                    Arrays.sort(resources, ResourceUtils.getResourceComparator());
                    for (int i = 0; i < resources.length; ++i) {
                        this.loadURI(resources[i], loadedURIs, includeStatement);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load from directory '" + directoryURI + "' at " + includeStatement.getLocation(), (Throwable)e);
            }
        }
    }

    protected void loadURI(Resource src, Set loadedURIs, Configuration includeStatement) throws ConfigurationException, IOException {
        String uri = this.correctUrl(this.getUrl(src));
        if (!loadedURIs.contains(uri)) {
            Configuration includeConfig;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading configuration: " + uri));
            }
            try {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder(true);
                includeConfig = builder.build(src.getInputStream(), uri);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load '" + uri + "' at " + includeStatement.getLocation(), (Throwable)e);
            }
            loadedURIs.add(uri);
            String includeKind = includeConfig.getName();
            if (includeKind.equals("components") || includeKind.equals("cocoon")) {
                this.parseConfiguration(includeConfig, uri, loadedURIs);
            } else if (includeKind.equals("role-list")) {
                this.configureRoles(includeConfig);
            } else {
                throw new ConfigurationException("Unknow document '" + includeKind + "' included at " + includeStatement.getLocation());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleBeanInclude(String contextURI, Configuration includeStatement) throws ConfigurationException {
        String includeURI = includeStatement.getAttribute("src", null);
        String directoryURI = null;
        if (includeURI == null) {
            directoryURI = includeStatement.getAttribute("dir", null);
        }
        if (includeURI == null && directoryURI == null) {
            throw new ConfigurationException("Include statement must either have a 'src' or 'dir' attribute, at " + includeStatement.getLocation());
        }
        if (includeURI != null) {
            try {
                Resource src = this.resolver.getResource(this.getUrl(includeURI, contextURI));
                this.configInfo.addImport(this.getUrl(src));
                return;
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load '" + includeURI + "' at " + includeStatement.getLocation(), (Throwable)e);
            }
        } else {
            Resource dirResource = this.resolver.getResource(this.getUrl(directoryURI, contextURI));
            if (dirResource.exists()) {
                String pattern = includeStatement.getAttribute("pattern", null);
                try {
                    Resource[] resources = this.resolver.getResources(this.getUrl(directoryURI + '/' + pattern, contextURI));
                    if (resources == null) return;
                    Arrays.sort(resources, ResourceUtils.getResourceComparator());
                    for (int i = 0; i < resources.length; ++i) {
                        this.configInfo.addImport(this.getUrl(resources[i]));
                    }
                    return;
                }
                catch (IOException ioe) {
                    throw new ConfigurationException("Unable to read configurations from " + directoryURI);
                }
            } else {
                if (includeStatement.getAttributeAsBoolean("optional", false)) return;
                throw new ConfigurationException("Directory '" + directoryURI + "' does not exist (" + includeStatement.getLocation() + ").");
            }
        }
    }

    protected final void configureRoles(Configuration configuration) throws ConfigurationException {
        Configuration[] roles = configuration.getChildren();
        for (int i = 0; i < roles.length; ++i) {
            Configuration[] keys;
            String previous;
            String shorthand;
            String roleName;
            Configuration role = roles[i];
            if ("alias".equals(role.getName())) {
                roleName = role.getAttribute("role");
                shorthand = role.getAttribute("shorthand");
                this.configInfo.getShorthands().put(shorthand, roleName);
                continue;
            }
            if (!"role".equals(role.getName())) {
                throw new ConfigurationException("Unexpected '" + role.getName() + "' element at " + role.getLocation());
            }
            roleName = role.getAttribute("name");
            shorthand = role.getAttribute("shorthand", null);
            String defaultClassName = role.getAttribute("default-class", null);
            if (shorthand != null && (previous = this.configInfo.getShorthands().put(shorthand, roleName)) != null && !previous.equals(roleName)) {
                throw new ConfigurationException("Shorthand '" + shorthand + "' already used for role " + previous + ": inconsistent declaration at " + role.getLocation());
            }
            if (defaultClassName != null) {
                ComponentInfo info = this.configInfo.getRole(roleName);
                if (info == null) {
                    info = new ComponentInfo();
                    info.setComponentClassName(defaultClassName);
                    info.fill(role);
                    info.setRole(roleName);
                    info.setConfiguration(role);
                    info.setAlias(shorthand);
                    this.configInfo.addRole(roleName, info);
                } else if (!defaultClassName.equals(info.getComponentClassName())) {
                    throw new ConfigurationException("Invalid redeclaration: default class already set to " + info.getComponentClassName() + " for role " + roleName + " at " + role.getLocation());
                }
            }
            if ((keys = role.getChildren("hint")).length <= 0) continue;
            HashMap<String, ComponentInfo> keyMap = (HashMap<String, ComponentInfo>)this.configInfo.getKeyClassNames().get(roleName);
            if (keyMap == null) {
                keyMap = new HashMap<String, ComponentInfo>();
                this.configInfo.getKeyClassNames().put(roleName, keyMap);
            }
            for (int j = 0; j < keys.length; ++j) {
                Configuration key = keys[j];
                String shortHand = key.getAttribute("shorthand").trim();
                String className = key.getAttribute("class").trim();
                ComponentInfo info = (ComponentInfo)keyMap.get(shortHand);
                if (info == null) {
                    info = new ComponentInfo();
                    info.setComponentClassName(className);
                    info.fill(key);
                    info.setConfiguration(key);
                    info.setAlias(shortHand);
                    keyMap.put(shortHand, info);
                    continue;
                }
                if (className.equals(info.getComponentClassName())) continue;
                throw new ConfigurationException("Invalid redeclaration: class already set to " + info.getComponentClassName() + " for hint " + shortHand + " at " + key.getLocation());
            }
        }
    }
}

